﻿$(document).ready(function () {
    initDocument(document);
    questionnaireEditor.setRowLogicEvent(document);
});

var initDocument = function (context) {
    // General controls 
    questionnaireEditor.setRandomizationPattern(context);
    questionnaireEditor.setRepeatHeaders(context);
    questionnaireEditor.setDimensionSelector(context);
    questionnaireEditor.setMinMaxValueChangeEvent(context);
    questionnaireEditor.setMinMaxSelectorChangeEvent(context);

    // Text Answer
    questionnaireEditor.setTextAnswerMultiLineEvent(context);

    // Numeric Answer
    questionnaireEditor.setNumericAnswerNumberOfDecimalsEvent(context);

    // File Upload
    questionnaireEditor.setFileUploadEvent(context);

    // Choice list
    questionnaireEditor.setAddChoiceRowEvent(context);
    questionnaireEditor.setAddSystemChoiceRowEvent(context);
    questionnaireEditor.setSelectDefaultChoiceEvent(context);
    questionnaireEditor.setChoiceCodeChange(context);
    questionnaireEditor.setStopUsingChoicesEvent(context);
    questionnaireEditor.setChoiceOpenEndTypeEvent(context);
    questionnaireEditor.setChoiceHeaderEvent(context);
    questionnaireEditor.setEditChoiceOpenEndSettingsEvent(context);
    questionnaireEditor.setShowOpenEndsEvents(context);
    questionnaireEditor.setEditChoices(context);
    questionnaireEditor.setImportChoicesEvent(context);
    questionnaireEditor.setChoiceListAnswerType(context);

    // Images
    questionnaireEditor.setDisableImageMapInvalidCharactersRowEvent(context);
    questionnaireEditor.setAddImageAreaChoice(context);
    questionnaireEditor.setDeleteImageAreaChoice(context);
    questionnaireEditor.setImageMapAreaSaveEvents(context);

    questionnaireEditor.setImageAreaEvaluatorEvents(context);

    questionnaireEditor.setChangeImageMapUrl(context);
    questionnaireEditor.setAddImageMapAreaRowEvent(context);
    questionnaireEditor.setDeleteImageMapAreaRowEvent(context);

    // Slider
    questionnaireEditor.setAddSliderStyleEvent(context);
    questionnaireEditor.setEditSliderStyleEvent(context);
    questionnaireEditor.setDeleteSliderStyleEvent(context);
    questionnaireEditor.setSliderStyleChangeEvent(context);
    questionnaireEditor.setSliderDisplayTicksEvent(context);
    questionnaireEditor.setSliderDisplayNoAnswerEvent(context);
    questionnaireEditor.setSliderVariableTypeEvent(context);

    // Date Answer
    questionnaireEditor.registerDateAnswerTypeChangeEvent(context);

    // Card Sort
    questionnaireEditor.setAddCardRowEvent(context);
    questionnaireEditor.setEditCardLogicRowEvent(context);
    questionnaireEditor.disableCardsInvalidCharactersEvent(context);

    // Text Highlighter
    questionnaireEditor.setTextHighlighterEvents(context);
    questionnaireEditor.setAddHighlightCategoryRowEvent(context);
    questionnaireEditor.setEditHighlightCategoryLogicRowEvent(context);
    questionnaireEditor.disableHighlightCategoriesInvalidCharactersEvent(context);

    //Drag And Drop Ranking


    // Drilldown 
    questionnaireEditor.setEditDropdownChoices(context);
    questionnaireEditor.setAddDropdownRowEvent(context);
    questionnaireEditor.setEditDrillDownDropdown(context);
    questionnaireEditor.setEditDropdownOptions(context);
    questionnaireEditor.setAddLinkedItemsEvent(context);
    questionnaireEditor.setImportLinkedChoicesEvent(context);

    //AutoComplete
    questionnaireEditor.setAutoCompleteInvalidAsOpenEndEvent(context);
    questionnaireEditor.setAutoCompleteShowDropDownEvent(context);

    //Carousel
    questionnaireEditor.setCarouselQuestionEvent(context);
    questionnaireEditor.updateCarouselAllStatementDimensions(context);

    // Question type common
    questionnaireEditor.setAddMultipleItemsEvent(context);
    questionnaireEditor.setRowEvents(context);
    questionnaireEditor.setQuestionsRandomizationEditor(context);

    // Logic
    a4logicEditor.initializeEditors(context);

    a4.fixPostForInput($('.v-blockItemPanel', context));
};

//----------------------- CHOICE CONTROLS -------------------

questionnaireEditor.toggleOpenEnd = function (input, singleChoice, container) {
    if (container == null) {
        container = input.parents(".choiceList");
    }

    var openEnd = $("#" + input.attr("id") + "_openEnd", container);
    var openEndDiv = openEnd.parent();
    var hasHidden = openEndDiv.hasClass("openEndHidden");
    var isChecked = input.is(":checked");

    if (singleChoice) {
        $(".openEndHidden", container).hide();
        $(".openEnd", container).prop("disabled", true);
    }

    if (openEndDiv.length > 0) {
        if (hasHidden) {
            openEndDiv.toggle(isChecked);
        }

        openEnd.prop("disabled", !isChecked);
    }
}

questionnaireEditor.setShowOpenEndsEvents = function (context) {
    $(context).on("click", ".v-questionPreview .choiceList :checkbox", function () {
        questionnaireEditor.toggleOpenEnd($(this));
    });

    $(context).on("click", ".v-questionPreview .choiceList :radio", function () {
        questionnaireEditor.toggleOpenEnd($(this), true);
    });

    $(context).on("change", ".v-questionPreview .choiceList select", function () {
        var choice = $(this).find(":selected");
        questionnaireEditor.toggleOpenEnd(choice, true);
    });
}

// --------------- Choice List - Functions ------------------------------------

$.fn.choiceEditor = function (options, allowMultipleSelection) {
    // Use this to enable or disable columns in a choice editor
    if (options) {
        var hashPropertyClass = {
            DisplayAvailableChoiceColumn: '.available-choice',
            DisplayTextColumn: '.choice-text',
            DisplayIndexColumn: '.choice-index',
            DisplayCodeColumn: '.choice-code',
            DisplayDefaultColumn: '.choice-default',
            DisplayExclusiveColumn: '.choice-exclusive',
            DisplayFixedColumn: '.choice-fixed',
            DisplayImageColumn: '.choice-image',
            DisplayColorColumn: '.choice-color',
            DisplayOpenEndColumn: '.choice-openEnd',
            DisplayHeaderColumn: '.choice-header',
            ShowChoiceListSelector: '.choice-parent'
        };

        var showSelector = [];
        var hideSelector = [];

        _.each(hashPropertyClass, function (value, key) {
            if (options[key] !== undefined) {
                if (options[key]) {
                    showSelector.push(value);
                } else {
                    hideSelector.push(value);
                }
            }
        });

        if (showSelector.length > 0) {
            $(showSelector.join(','), this).show();
        }
        if (hideSelector.length > 0) {
            $(hideSelector.join(','), this).hide();
        }
    }

    return this;
};

questionnaireEditor.initializeChoiceEditor = function (panel) {
    var choiceListEditor = $(".v-choiceList", panel);
    var choiceListTable = $(".v-choiceListTable", choiceListEditor);

    var hashPropertyClass = {
        DisplayAvailableChoiceColumn: '.available-choice',
        DisplayIndexColumn: '.choice-index',
        DisplayCodeColumn: '.choice-code',
        DisplayDefaultColumn: '.choice-default',
        DisplayExclusiveColumn: '.choice-exclusive',
        DisplayFixedColumn: '.choice-fixed',
        DisplayImageColumn: '.choice-image',
        DisplayColorColumn: '.choice-color',
        DisplayOpenEndColumn: '.choice-openEnd',
        DisplayHeaderColumn: '.choice-header',
        ShowChoiceListSelector: '.choice-parent'
    };

    $.each(hashPropertyClass, function (value, key) {
        if ($("th" + key, choiceListTable).attr("data-show") == "false") {
            $(key, choiceListEditor).addClass("hidden");
        }
    });

    a4.setColorPickers($(".v-colorPicker", choiceListTable));

    $(".v-choiceCode", panel).on("keypress", function (_e) { return DisableInvalidCharacters(_e); });
    $("input", panel).on("keypress", function (_e) { return DisableEnter(_e); });
}

questionnaireEditor.setChoiceListColumns = function (choiceListEditor) {
    $(".v-choiceListTable thead th.hidden", choiceListEditor).each(function () {
        choiceListEditor.find("." + $(this).attr("class").split(' ')[0]).hide();
    });
}

questionnaireEditor.setSelectDefaultChoiceEvent = function (context) {
    $(context).on("change", ".v-choiceListEditor .v-choiceListTable .v-defaultChoice:checkbox", function () {
        var choiceTable = $(this).closest(".v-choiceListTable");
        if (choiceTable.attr("data-multipleselection") == "false") {
            $(".v-defaultChoice:checkbox", choiceTable).not($(this)).prop("checked", false);
        }
    });
}

questionnaireEditor.setAddChoiceRowEvent = function (context) {
    $(context).on("click", ".v-choiceListEditor .v-addPanel .h-addItemRow", function () {
        questionnaireEditor.addChoiceRow($(this));
    });
}

questionnaireEditor.getLastChoiceCode = function (choiceListEditor, choiceIndex) {
    var lastRow = $("table .v-choiceListBody .v-questionEditableItem:visible", choiceListEditor).last();
    lastCode = (lastRow.length > 0) ? parseInt($(".v-choiceCode", lastRow).val()) : 0;
    return (Number(lastCode)) ? lastCode : choiceIndex;
}

questionnaireEditor.addChoiceRow = function (button) {
    var choiceListEditor = button.closest(".v-choiceListEditor");
    var choice = $($(".v-newChoice tbody tr", choiceListEditor).clone(false));
    var lastCode = 0;

    if (questionnaireEditor.batchInsert && questionnaireEditor.batchInsertCode != 0) {
        lastCode = ++questionnaireEditor.batchInsertCode;
    }
    else {
        var choiceIndex = $("table .v-choiceListBody .v-questionEditableItem:visible", choiceListEditor).length;
        $(".v-itemIndex", choice).html(choiceIndex + 1);
        lastCode = questionnaireEditor.getLastChoiceCode(choiceListEditor, choiceIndex) + 1;
        questionnaireEditor.batchInsertCode = lastCode;
    }

    $(".v-choiceCode", choice).val(lastCode);
    choice.appendTo($("table .v-choiceListBody", choiceListEditor));

    choiceListEditor.trigger('rowAdded', choice);

    var parentFrame = getParentFrame();

    if (parentFrame && parentFrame.choiceRowAdded) {
        parentFrame.choiceRowAdded(choice);
    }
    else {
        a4ImageSelector.bindElements(choice);
    }

    if (!questionnaireEditor.batchInsert) {
        $('.v-qeRichEditText', choice).a4richTextEditor({ library: true, piping: true, inline: true });
    }

    a4.setColorPickers($(".v-choiceColorColumn:not(.hidden) .v-colorPicker", choice));
}

questionnaireEditor.setChoiceOpenEndTypeEvent = function (context) {
    $(context).on("change", ".v-choiceOpenEndType", function () {
        var row = $(this).closest(".v-questionEditableItem");
        var openEndSettings = $(".v-openEndDivision", row);

        if ($(this).is(":checkbox"))
            openEndSettings.toggle($(this).is(":checked"));
        else
            openEndSettings.toggle($(this).val() != "None");
    });
}

questionnaireEditor.setChoiceHeaderEvent = function (context) {
    $(context).on("click", ".v-headerChoice", function () {
        var row = $(this).closest(".v-questionEditableItem");
        var isChecked = $(".v-headerChoice", row).is(":checked");

        if (isChecked) {
            $(".v-choiceOpenEndType", row).val("None");
            var openEndSettings = $(".v-openEndDivision", row);
            openEndSettings.toggle($(".v-choiceOpenEndType", row).val() != "None");
            $(".v-choiceCode", row).prop('disabled', true).attr("data-prev", $(".v-choiceCode", row).val());
            $(".v-choiceCode", row).val("");
            $(".v-defaultChoice", row).prop("checked", false);
            $(".v-exclusiveChoice", row).prop("checked", false);
            $(".v-choiceOpenEndType", row).prop('disabled', true);
            $(".v-defaultChoice", row).prop('disabled', true);
            $(".v-exclusiveChoice", row).prop('disabled', true);

        }
        else {
            $(".v-choiceCode", row).removeAttr('disabled');
            $(".v-choiceOpenEndType", row).removeAttr('disabled');
            $(".v-defaultChoice", row).removeAttr('disabled');
            $(".v-exclusiveChoice", row).removeAttr('disabled');
            $(".v-fixedChoice", row).removeAttr('disabled');

            var prevCode = $(".v-choiceCode", row).attr("data-prev");
            $(".v-choiceCode", row).val(prevCode);
        }
    });
}

questionnaireEditor.setEditChoiceOpenEndSettingsEvent = function (context) {
    $(context).on("click", ".v-choiceOpenEndSettings", function () {
        var top$ = a4.top().jQuery;
        var container = top$(this).closest(".v-questionEditableItem");

        var editor = top$(this).closest(".v-questionEdit");
        var settings = $(".v-openEndSettings", questionnaireEditor.container);
        var qType = editor.attr("data-qtype");

        var widthHidden = $("input[type=hidden][data-name='Width']", settings);
        widthHidden.attr('value', $(".v-choiceOpenEndWidth", container).val());
        questionnaireEditor.updateDimensionSelectorValue(widthHidden, true);

        var heightHidden = $("input[type=hidden][data-name='Height']", settings);
        heightHidden.attr('value', $(".v-choiceOpenEndHeight", container).val());
        questionnaireEditor.updateDimensionSelectorValue(heightHidden, true);

        $(".v-openEndLines", settings).attr("value", $(".v-choiceOpenEndLines", container).val());

        var openEndSize = $(".v-choiceOpenEndSize", container).val();

        //Default open end size is full for radios and checkboxes
        if (!openEndSize && (qType == "1" || qType == "3")) {
            openEndSize = "Full";
        }

        if (openEndSize) {
            $(".v-openEndSize option[selected]", settings).removeAttr("selected");
            $(".v-openEndSize option[value='" + openEndSize + "']", settings).attr("selected", "selected");
        }

        $(".v-openEndMaxLength", settings).attr("value", $(".v-choiceOpenEndMaxLength", container).val());
        $(".v-openEndMinLength", settings).attr("value", $(".v-choiceOpenEndMinLength", container).val());
        $(".v-displayWhenSelected", settings).attr("checked", $(".v-choiceOpenEndDisplayWhenSelected", container).val() == "true");
        $(".v-enforceOpenEnd", settings).attr("checked", $(".v-choiceEnforceOpenEnd", container).val() == "true");

        var hasDropdowns = (qType == "2" || qType == "23");
        $(".v-displayWhenSelectedContainer", settings).toggle(!hasDropdowns); // Not for drop-down and drilldown

        questionnaireEditor.confirmOpenEndSettingsResources.Message = settings.html();

        modalDialog.showConfirmDialog(questionnaireEditor.confirmOpenEndSettingsResources,
            function () {
                var editor = $(".modernEditor:visible");

                $(".v-choiceOpenEndWidth", container).val($("input[type=hidden][data-name='Width']", editor).val());
                $(".v-choiceOpenEndHeight", container).val($("input[type=hidden][data-name='Height']", editor).val());
                $(".v-choiceOpenEndSize", container).val($(".v-openEndSize", editor).val());
                $(".v-choiceOpenEndLines", container).val($(".v-openEndLines", editor).val());
                $(".v-choiceOpenEndMaxLength", container).val($(".v-openEndMaxLength", editor).val());
                $(".v-choiceOpenEndMinLength", container).val($(".v-openEndMinLength", editor).val());
                $(".v-choiceOpenEndDisplayWhenSelected", container).val($(".v-displayWhenSelected", editor).is(":checked"));
                $(".v-choiceEnforceOpenEnd", container).val($(".v-enforceOpenEnd", editor).is(":checked"));
            },
            380, 500, false, null,
            {
                validateFunction: function () {
                    var container = $(".modernEditor:visible");
                    var minLenght = parseInt($(".v-openEndMinLength", container).val());
                    var maxLenght = parseInt($(".v-openEndMaxLength", container).val());

                    if (!isNaN(minLenght) && !isNaN(maxLenght) && minLenght > maxLenght) {
                        a4.showErrorMessage(questionnaireEditor.resources.MaxValueLowerThanMinValue);
                        return false;
                    }
                    else
                        return true;
                }
            });
    });
}

questionnaireEditor.setChoiceCodeChange = function (context) {
    $(context).on("focusin", ".v-choiceListEditor .v-choiceCode", function () {
        $(this).attr("data-prev", $(this).val());
    });

    $(context).on("focusout", ".v-choiceListEditor .v-choiceCode", function () {
        var choiceListEditor = $(this).closest(".v-choiceListEditor");
        var prevVal = $(this).attr("data-prev");
        var value = $(this).val();

        if ($(".v-choicesByDropdown", choiceListEditor).length > 0 && prevVal && prevVal != value) {
            var dropdowns = $(this).closest(".v-drilldownEditorContainer").find(".v-dropdownTable .v-dropdownName");
            var dropdownVal = $(".v-choicesByDropdown option:selected", choiceListEditor).attr("data-value");

            var thisItem = dropdowns.filter("input[id='" + dropdownVal + "']");
            var index = dropdowns.index(thisItem);

            if (index < dropdowns.length - 1) {
                $(".v-questionEditableItem[data-variable='" + $(dropdowns.get(index + 1)).attr("id") + "']", choiceListEditor).each(function () {
                    if ($(this).find(".v-choiceParent").val() == prevVal) {
                        $(this).find(".v-choiceParent").val(value);
                    }
                });
            }
        }
    });
}

questionnaireEditor.setSelectMultipleChoicesWithAutoComplete = function (editor, columnIndex, questionId) {
    if (questionnaireEditor.currentEditor && questionnaireEditor.currentEditor.is(".gridEditor")) {
        var gridEditor = new GridEditor(questionnaireEditor.currentEditor);

        // choice grid
        $(".v-EliminationExcludedFields,.v-softPromptChoice", editor).each(function () {
            if (!columnIndex) columnIndex = 0;
            var data = function () {
                if (gridEditor.getGridType() == GridEditor.imageChoiceGridType || gridEditor.getGridType() == GridEditor.choiceGridType) {
                    return $.map(gridEditor.getColumnSettings()[columnIndex].Choices, function (choice, index) { return { Code: choice.Code, Text: choice.Code + " - " + choice.Text } });
                } else {
                    return $.map($(".v-questionEditableItem:visible", $(".v-choiceListBody", $(".v-choiceListEditor", editor))),
                        function (choiceRow, index) {
                            var code = $(".v-choiceCode", choiceRow).val();
                            var text = $(".v-choiceText", choiceRow).text();

                            return { Code: code, Text: code + " - " + text };
                        });
                }
            };
            $(this).a4autocomplete({ data: data, multipleSelection: !$(this).hasClass("v-softPromptChoice"), valueProperty: "Code", labelProperty: "Text" });
        });

        // other column defined grid (hybrid, star rating)
        $(".v-ColumnEliminationExcluded", editor).each(function () {
            var data = function () { return _.map(gridEditor.getColumnSettings(), function (column) { return (column) ? { Label: column.Label, Position: column.Position + 1 } : null }); };
            $(this).a4autocomplete({ data: data, multipleSelection: true, valueProperty: "Position", labelProperty: "Label", tooltipProperty: "Label" });
        });

        $(".v-RowEliminationExcluded", editor).each(function () {
            var data = function () {
                var rowPosition = 0;
                return _.map(_.filter(gridEditor.getRowSettings(), function (row) { return row && row.RowType == GridEditor.variableRowType }),
                    function (row) { return { Label: row.LeftLabel, Position: ++rowPosition } }
                );
            };
            $(this).a4autocomplete({ data: data, multipleSelection: true, valueProperty: "Position", labelProperty: "Label" });
        });
    } else {
        var choiceListEditor = $(".v-choiceListEditor, .v-systemChoiceEditor", editor);

        if (choiceListEditor.length > 0) {
            var choicesAutCompleteCallBack = function (data) {
                $(".v-EliminationExcludedFields,.v-softPromptChoice", editor).each(function () {
                    $(this).a4autocomplete({ data: data, multipleSelection: $(this).hasClass('v-EliminationExcludedFields'), valueProperty: "Code", labelProperty: "Text" });
                });
            };

            if (choiceListEditor.hasClass("v-largeListEditor")) {
                var choiceListId = $(".v-questionEditableItem:first", choiceListEditor).attr("data-listId");
                questionnaireEditor.loadLargeListChoices(choiceListId, null, false, choicesAutCompleteCallBack);
            }
            else {
                choicesAutCompleteCallBack(function () {
                    if ($(".v-choiceListBody", choiceListEditor).length > 0) {
                        return $.map($(".v-questionEditableItem:not(.deleted)", $(".v-choiceListBody", choiceListEditor)), function (choiceRow, index) {
                            var code = $(".v-choiceCode", choiceRow).val();
                            var text = $(".v-choiceText", choiceRow).text();

                            return (code) ? { Code: code, Text: code + " - " + text } : null;
                        });
                    }
                });
            }
        }
    }
}

questionnaireEditor.setSelectQuestionForChoicesEvent = function (context, override, useQuestionId) {
    var container = context.hasClass("v-useSameAsPanel") ? context : $(".v-choiceListEditor .v-listHeader", context)
    var notSetOnly = (override) ? "" : ":not(.autocomplete)";

    $(".v-selectQuestion" + notSetOnly, container).each(function () {
        var questionId = (useQuestionId) ? useQuestionId : questionnaireEditor.blockController.getBlockItemIdFromElement($(this));
        var choiceListEditor = $(this).closest(".v-choiceListEditor");
        var choiceInput = $(this).closest(".v-useSameAsPanel").find(".v-choiceListId");

        var container = choiceListEditor.closest(".v-blockItemPanel");
        var questionName = $(".h-questionTitle", container).text().trim();
        var typeVariables = _.map(_.filter(questionnaireEditor.variables, function (variable) { return variable.type == 0 && variable.questionId != questionId }),
            function (variable) { return { value: variable.choiceListId, label: variable.name, questionId: variable.questionId }; }).sort(questionnaireEditor.sortVariables);

        $(this).a4autocomplete({
            data: typeVariables,
            valueProperty: "value",
            labelProperty: "label",
            tooltipProperty: "questionId",
            tooltipData: function (autocomplete, tooltip, questionId) {
                a4.getTooltipQuestionText(autocomplete, tooltip, questionnaireEditor.Id, questionId);
            },
            select: function (event, data) {
                var value = $(event.target).val();
                var variable;

                if (!data.item) {
                    variable = questionnaireEditor.getVariableWithSameChoiceList(questionId, choiceInput.val());
                    $(this).val(variable);
                }
                else if (!$(event.target).attr("data-selected")) {
                    variable = questionnaireEditor.getVariableByName(value);
                    if (variable) {
                        questionnaireEditor.setUseChoiceListIdAfterChange(choiceListEditor, choiceInput, variable.choiceListId, null, variable);
                    }
                    else {
                        $(event.target).val("");
                    }
                }

                $(this).removeAttr("data-selected");
            }
        });
    });
}

questionnaireEditor.setUseChoiceListIdAfterChange = function (choiceList, choiceInput, choiceListId, sharedId, variable) {
    sharedId = (sharedId) ? sharedId : choiceListId;
    choiceInput.data("sharedid", sharedId);
    var useSameAsPanel = choiceInput.closest(".v-useSameAsPanel");
    $(".v-stopUsingChoices", useSameAsPanel).css("display", (variable) ? "inline-block" : "none");

    if (choiceInput.closest(".v-dropdownOptions").length == 0) {
        questionnaireEditor.reloadChoiceListContent(choiceList, choiceListId, variable);
    }
}


questionnaireEditor.setStopUsingChoicesEvent = function (context) {
    $(context).on("click", ".v-stopUsingChoices", function () {
        var usePanel = $(this).closest(".v-useSameAsPanel");
        $(".v-choiceListId", usePanel).data("sharedid", "0");
        $(".v-selectQuestion", usePanel).val("");
        $(this).hide();

        var choiceListEditor = $(this).closest(".v-choiceListEditor");

        if (choiceListEditor.length > 0) {
            var blockItemPanel = choiceListEditor.closest(".v-blockItemPanel");
            $(".v-choiceListTable .v-choiceListBody .v-questionEditableItem:visible", choiceListEditor).remove();

            if (choiceListEditor.hasClass("v-largeListEditor")) {
                $(".v-questionEditableItem:first").data("choices", []);
                $(".v-choiceCount").text("(0)");
            }
            else if ($(".imageAreaSelectorEditorContainer .imageMap", blockItemPanel).length > 0) {
                $(".imageAreaSelectorEditorContainer .imageMap .area", blockItemPanel).hide();
            }
        }
    });
}

questionnaireEditor.loadLargeListChoices = function (choiceListId, forChoiceListId, setChoices, callback) {
    return a4.callServerMethod(questionnaireEditor.getUrl("GetLargeChoiceListChoices"), { choiceListId: choiceListId },
        function (result) {
            if (setChoices) {
                var setChoiceListId = (forChoiceListId) ? forChoiceListId
                    : (result && _.size(result) > 0) ? _.first(result).ChoiceListId : 0;
                questionnaireEditor.setChoiceListChoices(setChoiceListId, result);
            }

            if (callback)
                callback(result);
        },
        function () {
            a4.showErrorMessage($(".unexpectedError").html());
        }
    );
}

// Should not be called directly - use  |
questionnaireEditor.reloadChoiceListContent = function (choiceListEditor, choiceListId, selectedVariable) {
    if (choiceListId > 0) {
        if (choiceListEditor.hasClass("v-largeListEditor")) {
            var setChoiceListId = $(".v-questionEditableItem:first", choiceListEditor).attr("data-listId");
            questionnaireEditor.loadLargeListChoices(choiceListId, setChoiceListId, true);
        }
        else {
            questionnaireEditor.loadSpecificChoiceEditor(choiceListEditor, choiceListId, selectedVariable);
        }
    }
    else {
        $(".v-choiceListTable .v-choiceListBody .v-questionEditableItem:visible", choiceListEditor).remove();
        var usePanel = $(".v-useSameAsPanel", choiceListEditor);
        $(".v-selectQuestion", usePanel).val("");
        $(".v-stopUsingChoices", usePanel).hide();
    }
}

questionnaireEditor.loadSpecificChoiceEditor = function (choiceListEditor, choiceListId, selectedVariable) {
    a4.callServerMethod(questionnaireEditor.getUrl("GetChoiceListCount"), { choiceListId: choiceListId },
        function (result) {
            if (result > questionnaireEditor.choiceListMaxRowCount) {
                var variable = choiceListEditor.attr("data-variables");
                var listId = questionnaireEditor.getVariableById(variable).choiceListId;

                var callback = function (newListEditor) {
                    var loadCallback = function (result) {
                        $(".v-selectQuestion", newListEditor).val(selectedVariable.name);
                        $(".v-useSameAsPanel .v-choiceListId", newListEditor).data("sharedid", choiceListId);
                        $(".v-stopUsingChoices", newListEditor).css("display", "inline-block");
                    }

                    questionnaireEditor.loadLargeListChoices(choiceListId, listId, true, loadCallback);
                }

                questionnaireEditor.switchChoiceEditorToLargeList(questionnaireEditor.getInEditQuestion(), choiceListEditor, callback);
            }
            else {
                a4.callServerMethod(questionnaireEditor.getUrl("GetChoiceListContent"), { choiceListId: choiceListId },
                    function (result) {
                        questionnaireEditor.updateChoiceListContent(choiceListEditor, result, choiceListId);
                    },
                    function () {
                        a4.showErrorMessage($(".unexpectedError").html());
                    }
                );
            }
        }
    );
}

questionnaireEditor.switchChoiceEditorToLargeList = function (editQuestion, choiceListEditor, callback) {
    editQuestion.addClass("needsReload");   // Panel reloaded in case of cancel
    var variable = choiceListEditor.attr("data-variables");
    var listId = questionnaireEditor.getVariableById(variable).choiceListId;
    var questionId = questionnaireEditor.blockController.getBlockItemIdFromElement(editQuestion);

    a4.callServerMethod(questionnaireEditor.getUrl("GetLargeChoiceListEditor"), { variableId: variable, questionId: questionId },
        function (result) {
            if (result) {
                choiceListEditor.replaceWith(result);
                var newListEditor = $(".v-largeListEditor", editQuestion);
                var listId = $(".v-questionEditableItem", newListEditor).attr("data-listId");
                questionnaireEditor.setSelectQuestionForChoicesEvent($(".v-useSameAsPanel", newListEditor), false);
                editQuestion.scrollIntoView();
                $(window).scrollTop($(window).scrollTop() - 60);

                if (callback) {
                    callback(newListEditor);
                }
            }
        }
    );
}

questionnaireEditor.updateChoiceListContent = function (choiceListEditor, content, choiceListId) {
    var container = choiceListEditor.closest(".v-blockItemPanel");
    var questionType = $(".v-questionEdit", container).attr("data-qtypename");
    var previousItems = $(".v-choiceListBody .v-questionEditableItem", choiceListEditor);

    $(".v-choiceListBody", choiceListEditor).append(content);
    $(".v-qeRichEditText:visible", choiceListEditor).a4richTextEditor({ library: true, piping: true, inline: true });

    previousItems.remove();

    if (questionType == IMAGE_AREA_SELECTOR) {
        questionnaireEditor.updateImageMapAreas(choiceListEditor, container);
    }

    questionnaireEditor.setChoiceListColumns(choiceListEditor);
    a4.setColorPickers($(".v-colorPicker", choiceListEditor));
    a4ImageSelector.bindElements(choiceListEditor);
}


questionnaireEditor.updateImageMapAreas = function (choiceListEditor, container) {
    var imageMap = $(".v-imageMap", container);
    $(".v-area", imageMap).hide();
    $(".v-itemIndex:visible", choiceListEditor).each(function () {
        questionnaireEditor.addNewImageMapArea(container, $(this).html());
    });
}

questionnaireEditor.setAddSystemChoiceRowEvent = function (context) {
    $(context).on("click", ".v-systemChoiceListEditor .v-addPanel .h-addItemRow", function () {
        var questionEditor = $(this).closest(".v-systemChoiceEditor");
        var choiceListEditor = $(".v-systemChoiceListEditor", questionEditor);

        var choice = $(".v-newChoice tbody tr", choiceListEditor).clone(false);
        $(choice).appendTo($("table .v-choiceListBody", choiceListEditor));
        $('.editable', choice).a4richTextEditor({ library: true, piping: true, inline: true });
        choiceListEditor.trigger('rowAdded', choice);

        var source = $(this).closest(".v-questionEdit").attr("data-qtypename");

        if (source != "") {
            var addedChoice = $("table .v-choiceListBody .v-questionEditableItem", choiceListEditor).last();
            questionnaireEditor.setSystemChoiceWithAutoComplete(addedChoice, source);
        }

        $(this).scrollIntoView();
    });
}

questionnaireEditor.setSystemChoiceWithAutoComplete = function (choiceRow, source) {
    var choiceListEditor = choiceRow.closest(".v-systemChoiceListEditor");
    var choiceText = $(".v-choiceText", choiceRow);
    var choiceValue = $(".v-choiceCode", choiceRow);
    var availableChoice = $(".v-availableChoice", choiceRow);
    var dataSource = (source == "RespondentTimeZone") ? questionnaireEditor.timeZones : questionnaireEditor.languages;

    if (choiceValue.val()) {
        var value = _.find(dataSource, function (v) { return v.value == choiceValue.val() });
        if (value) {
            availableChoice.val(value.name);
            choiceValue.attr("value", choiceValue.val());
        }
    }

    availableChoice.a4autocomplete({
        data: dataSource,
        valueProperty: "value",
        labelProperty: "name",
        minLength: 0,
        delay: 0,
        select: function (event, ui) {
            if (choiceValue.val() != ui.item.value) {
                if ($(".v-questionEditableItem:visible .v-choiceCode[value='" + ui.item.value + "']", choiceListEditor).length == 0) {
                    choiceValue.val(ui.item.value).attr("value", ui.item.value);
                    choiceText.a4richTextEditor("setContent", ui.item.name)
                    availableChoice.val(ui.item.name);
                }
                else {
                    choiceValue.val("").attr("value", "");
                    choiceText.a4richTextEditor("setContent", "")
                    availableChoice.val("");
                }
            }
        }
    });
}

questionnaireEditor.setSystemChoicesWithAutoComplete = function (editor) {
    var source = $(".v-questionEdit", editor).attr("data-qtypename")

    $(".v-choiceListTable .v-questionEditableItem", editor).each(function () {
        questionnaireEditor.setSystemChoiceWithAutoComplete($(this), source);
    });

    //CHECK
    editor.on("keypress", ".v-choiceListTable .v-questionEditableItem input", function (e) { return DisableEnter(e); });
}

questionnaireEditor.setEditChoices = function (context) {
    $(context).on("click", ".v-largeListEditor .h-editChoices", function () {
        var container = $(this).closest(".v-largeListEditor");
        var choiceList = $(".v-questionEditableItem", container);
        var choiceListId = choiceList.attr("data-listId")
        var sharedQuestion = $(".v-selectQuestion", container).val();
        var load = choiceList.data("choices") === undefined;

        modalDialog.showWindow(questionnaireEditor.getUrl("ChoiceListTable", { choiceListId: choiceListId, load: load, shared: sharedQuestion }), 700, 850);
    });
}

questionnaireEditor.getChoiceListChoices = function (choiceListId, choices) {
    var question = $(".v-blockItemPanel.inEdit", questionnaireEditor.container);
    var list = $(".v-questionEditableItem[data-listId='" + choiceListId + "']", question);
    return list.data("choices") ? list.data("choices") : null;
}

questionnaireEditor.setChoiceListChoices = function (choiceListId, choices) {
    var question = $(".v-blockItemPanel.inEdit", questionnaireEditor.container);

    // In case we just closed the question
    if (question.length == 0) {
        question = questionnaireEditor.blockController.getBlockItemElementFromId(questionnaireEditor.configuration["BlockItemId"]);
    }
    else
        question.addClass("needsReload");

    var list = $(".v-questionEditableItem[data-listId='" + choiceListId + "']", question);
    list.data("choices", choices);

    if ($(".v-choiceCount", question).length > 0) {
        $(".v-choiceCount", question).text("(" + _.size(_.filter(choices, function (c) { return !c.Deleted; })) + ")");
    }
}

questionnaireEditor.setChoiceListAnswerType = function (context) {
    $(context).on("click", ".choice-list-answer-type  input[type=radio]", function () {
        var container = $(this).closest(".choiceListAnswerTypeEditor");
        var questionType = container.attr("choice-list-answer-type");
        $("[data-name='" + questionType + "ChoiceListAnswerType']", container).val($(this).val());
        questionnaireEditor.updateCardListSettingOptions($(this).closest('.v-blockItemPanel'), $(this).val());
    });
}

questionnaireEditor.updateCardListSettingOptions = function (_panel, value, isOnLoadAction) {
    var isRadio = value == "RadioButton";
    $(".v-minMaxContainer", _panel).toggle(!isRadio);
    $(".choice-exclusive", _panel).toggle(!isRadio);

    var navigationSetting = $(".advance-setting-navigation-options", _panel);

    var autoAdvanceVariable = $(".advance-setting-navigation-options input[type=checkbox][data-name=AutoAdvanceVariable]", _panel);
    autoAdvanceVariable.parent().toggle(isRadio);

    if (isRadio) {
        $(".v-minMaxContainer input", _panel).val("");
        if (navigationSetting.length > 0) {
            if (!isOnLoadAction) {
                autoAdvanceVariable.prop('checked', false);
            }
        }
    }
    else {
        autoAdvanceVariable.prop('checked', false);
    }
};

// ---------------- Image Area Selector - Functions ---------------------------------

var imageMapPadding = 3;
var imageMapAreaWidth = 100;
var imageMapAreaHeight = 30;

questionnaireEditor.setImageAreaSelector = function (panel) {
    $(".v-questionPreview .imageMap", panel).each(function () {
        $(this).disableSelection();
        var selectedChoices = new Array();
        var imageMap = $(this);

        $("img", imageMap).imagesLoaded().always(function (instance) {
            $.each(instance.images, function (key, value) {
                var image = $(value.img);
                var width = image.width();
                var height = image.height();

                $(".area", imageMap).each(function () {
                    $(this).width(Math.min($(this).attr("data-width") * width, width));
                    $(this).height(Math.min($(this).attr("data-height") * height, height));
                    $(this).css("left", Math.ceil($(this).attr("data-left") * width));
                    $(this).css("top", Math.ceil($(this).attr("data-top") * height));
                    var checkBox = $(":checkbox", $(this));

                    if (checkBox.is(":checked")) {
                        selectedChoices.push(checkBox.attr("id"));
                    }
                });

                image.data("selectedChoices", selectedChoices);
            });
        });
    });
}

questionnaireEditor.setImageAreaSelectorEvents = function (panel) {

    $(panel).on("mouseenter", ".v-questionPreview .imageMap .area", function () {
        if (!$(this).hasClass("selectedImageArea")) {
            $(this).addClass("highlightedImageArea");
            questionnaireEditor.updateImageAreaSelectorAreaColor($(this));
        }
    });

    $(panel).on("mouseleave", ".v-questionPreview .imageMap .area", function () {
        if (!$(this).hasClass("selectedImageArea")) {
            $(this).removeClass("highlightedImageArea");
            questionnaireEditor.updateImageAreaSelectorAreaColor($(this));
        }
    });

    $(panel).on("click", ".v-questionPreview .imageMap .area", function () {
        var checkBox = $(":checkbox", $(this));
        var imageMap = $(this).closest(".imageMap");
        var maxAnswers = imageMap.attr("data-maxanswers");
        var selectedChoices = imageMap.data("selectedChoices");

        if (!selectedChoices) {
            selectedChoices = new Array();
        }

        if (checkBox.is(":checked")) {
            selectedChoices = $.grep(selectedChoices, function (value) { return value != checkBox.attr("id"); });
            checkBox.prop("checked", false);
            $(this).removeClass("selectedImageArea");
            $(this).addClass("highlightedImageArea");
        }
        else {
            if (checkBox.attr("data-exclusive") == "true") {
                $(":checkbox", imageMap).prop("checked", false);
                $(".area", imageMap).removeClass("selectedImageArea");
                selectedChoices = new Array();
            }
            else if (maxAnswers != null && maxAnswers > 0 && selectedChoices != null && selectedChoices.length >= maxAnswers) {
                var checkBoxToUncheck = $("#" + selectedChoices[0]);
                var area = checkBoxToUncheck.closest(".area");
                selectedChoices.splice(0, 1);
                checkBoxToUncheck.prop("checked", false);
                area.removeClass("selectedImageArea");
            }

            var exclusiveChoice = $(":checkbox[data-exclusive='true']:checked", imageMap);
            exclusiveChoice.prop("checked", false);
            exclusiveChoice.closest(".area").removeClass("selectedImageArea");
            selectedChoices = $.grep(selectedChoices, function (value) { return value != exclusiveChoice.attr("id"); });

            checkBox.prop("checked", true);
            $(this).removeClass("highlightedImageArea");
            $(this).addClass("selectedImageArea");
            selectedChoices.push(checkBox.attr("id"));
        }

        $(".area", imageMap).each(function () {
            questionnaireEditor.updateImageAreaSelectorAreaColor($(this));
        });

        imageMap.data("selectedChoices", selectedChoices);
    });
}

questionnaireEditor.updateImageAreaSelectorAreaColor = function (area) {
    var color;

    if (area.hasClass("selectedImageArea")) {
        color = area.attr("data-color");
    }
    else if (area.hasClass("highlightedImageArea")) {
        var imageMap = area.closest(".imageMap");
        color = imageMap.attr("data-highlightcolor");
    }

    if (color) {
        area.css("background-color", color);
    }
    else {
        area.css("background-color", "");
    }
}

questionnaireEditor.setImageMapAreaPositions = function (itemIndex, itemRow, areaObject) {
    var container = itemRow.closest(".v-questionEdit");
    var imageMap = $(".v-imageMap", container);
    var image = $(".v-imageMapImage", imageMap);
    var imageWidth = image.width();
    var imageHeight = image.height();

    var imageMapArea = questionnaireEditor.getImageMapArea(itemIndex, imageMap);
    var position = imageMapArea.position();

    areaObject.Top = ((position.top - imageMapPadding) / imageHeight).toFixed(4);
    areaObject.Left = ((position.left - imageMapPadding) / imageWidth).toFixed(4);
    areaObject.Height = (imageMapArea.outerHeight() / imageHeight).toFixed(4);
    areaObject.Width = (imageMapArea.outerWidth() / imageWidth).toFixed(4);
}

questionnaireEditor.updateImageMapDimensions = function (container) {
    var imageMap = $(".v-imageMapContainer .v-imageMap", container);
    var imageMapImage = $(".v-imageMapImage", imageMap);

    var width = imageMapImage.width();
    var height = imageMapImage.height();

    var newWidth = $(".v-setting[data-name=Width]", container).val();
    var newHeight = $(".v-setting[data-name=Height]", container).val();

    imageMapImage.css("width", newWidth);
    imageMapImage.css("height", newHeight);

    var widthRatio = imageMapImage.width() / width;
    var heightRatio = imageMapImage.height() / height;

    questionnaireEditor.updateImageMapAreasDimensions(imageMap, widthRatio, heightRatio);
}

questionnaireEditor.updateImageMapAreasDimensions = function (imageMap, widthRatio, heightRatio) {
    $(".v-area", imageMap).each(function () {
        var position = $(this).position();

        $(this).width($(this).width() * widthRatio);
        $(this).height($(this).height() * heightRatio);
        $(this).css("left", ((position.left - imageMapPadding) * widthRatio) + imageMapPadding);
        $(this).css("top", ((position.top - imageMapPadding) * heightRatio) + imageMapPadding);
    });
}

questionnaireEditor.addNewImageMapArea = function (container, index) {
    var imageMap = $(".v-imageMap", container);
    var imageMapArea = $("<div class='area v-area' data-index='" + index + "'>").append($("<div class='v-areaText'>").append(index));

    imageMapArea.width(imageMapAreaWidth);
    imageMapArea.height(imageMapAreaHeight);
    imageMapArea.css("top", imageMapPadding);
    imageMapArea.css("left", imageMapPadding);
    imageMapArea.css("z-index", 30);

    imageMap.append(imageMapArea);

    questionnaireEditor.setImageMapAreaEvents(imageMapArea);
}

questionnaireEditor.getImageMapArea = function (itemIndex, imageMap) {
    return $(".v-area:visible[data-index='" + itemIndex + "']", imageMap);
}

questionnaireEditor.replaceAreaIndexes = function (startItem) {
    var previousIndex = startItem.attr("data-index");
    var tempIndex = "";
    startItem.nextAll(".v-area:visible").each(function () {
        tempIndex = $(this).attr("data-index");
        $(this).attr("data-index", previousIndex);
        $(".v-areaText", $(this)).html(previousIndex);
        previousIndex = tempIndex;
    });
}

questionnaireEditor.initializeImageMapEditor = function (panel) {
    var editPanel = $(".v-questionEdit", panel);
    var imageMap = $(".v-imageMap", editPanel);
    var imageSrc = $(".v-imageUrl", editPanel).val();

    if (imageMap.length > 0) {
        $(".v-imageMapImage", imageMap).attr("src", imageSrc).imagesLoaded().always(function (instance) {
            $.each(instance.images, function (key, value) {
                var image = $(value.img);
                var imageWidth = image.width();
                var imageHeight = image.height();

                $(".v-area", imageMap).each(function () {
                    $(this).show();

                    var areaWidth = $(this).attr("data-width");
                    var areaHeight = $(this).attr("data-height");
                    var areaLeft = $(this).attr("data-left");
                    var areaTop = $(this).attr("data-top");

                    $(this).width((areaWidth * imageWidth) - 2);
                    $(this).height((areaHeight * imageHeight) - 2);
                    $(this).css("left", (areaLeft * imageWidth) + imageMapPadding);
                    $(this).css("top", (areaTop * imageHeight) + imageMapPadding);

                    questionnaireEditor.setImageMapAreaEvents($(this));
                });
            });
        });
    }
}

// ---------------- Image Area Selector - Events ---------------------------------

questionnaireEditor.setAddImageMapAreaRowEvent = function (context) {
    $(context).on("click", ".v-areaEditor .v-areasContainer .h-addItemRow", function () {
        var container = $(this).closest(".v-imageAreaSelectorEditorContainer");
        var index = $(".v-areasContainer .v-itemIndex", container).length + 1;
        questionnaireEditor.addNewImageMapArea(container, index);

        // New questions
        if ($(this).closest(".v-areaEditor").length == 0) {
            questionnaireEditor.addNewItemRow($(this));
        }
        else {
            var areaRow = $(".v-areaEditor .v-newItem .v-questionEditableItem", container).clone(false);
            var questionName = container.closest(".v-questionEdit").find(".v-questionName", container).val();
            var variableName = questionName.toUpperCase() + "_" + index;
            $(".v-variableNameColumn .v-variableName", areaRow).val(variableName);
            $(areaRow).appendTo($(".v-areaListTable .v-itemsBody", container));
            $('.v-qeRichEditText', areaRow).a4richTextEditor({ library: true, piping: true, inline: true });
        }

        $(".v-areasContainer .v-itemIndex:last", container).html(index).show();
    });
}

questionnaireEditor.setDeleteImageMapAreaRowEvent = function (context) {
    $(context).on("click", ".v-areasContainer .h-deleteRow", function () {
        var container = $(this).closest(".v-questionEdit");
        var areaRow = $(this).closest(".v-questionEditableItem");
        var itemIndex = $(".v-itemIndex", areaRow).html();
        var imageMap = $(".v-imageMap", container);
        var imageMapArea = questionnaireEditor.getImageMapArea(itemIndex, imageMap);

        questionnaireEditor.replaceItemIndexes(areaRow)
        questionnaireEditor.replaceAreaIndexes(imageMapArea);

        areaRow.hide();
        imageMapArea.hide();
    });
}
questionnaireEditor.setImageMapAreaSaveEvents = function (context) {
    questionnaireEditor.container.on("click", '.v-questionEdit[data-qtypename="ImageAreaSelector"] .h-saveQuestion, .v-questionEdit[data-qtypename="ImageAreaEvaluator"] .h-saveQuestion', function () {
        var container = $(this).closest(".v-questionEdit");
        var image = container.find(".v-imageMapImage");
        var imageWidth = image.width();
        var imageHeight = image.height();
        var areas = container.find(".v-imageMapContainer .v-imageMap .v-area");

        areas.each(function () {
            if ($(this).css('display') == 'none') {
                $(this).remove();
            }
            else {
                $(this).attr("data-width", (($(this).width() + 2) / imageWidth));
                $(this).attr("data-height", (($(this).height() + 2) / imageHeight));
                $(this).attr("data-left", (($(this).css("left").replace(/[^-\d\.]/g, '') - imageMapPadding) / imageWidth));
                $(this).attr("data-top", (($(this).css("top").replace(/[^-\d\.]/g, '') - imageMapPadding) / imageHeight));
            }
        });
    });
}

questionnaireEditor.setChangeImageMapUrl = function (context) {
    var urlInput = $(".h-imageUrl", context);
    $(context).on("change", ".h-imageUrl", function () {
        var container = $(this).closest(".v-questionEdit");
        var imageMap = $(".v-imageMapContainer .v-imageMap", container);
        var imageMapImage = $(".v-imageMapImage", imageMap);

        var width = imageMapImage.width();
        var height = imageMapImage.height();

        var imageSrc = $(this).val();


        imageMapImage.attr("src", imageSrc).imagesLoaded().always(function (instance) {
            $.each(instance.images, function (key, value) {
                var image = $(value.img);
                var widthRatio = image.width() / width;
                var heightRatio = image.height() / height;

                questionnaireEditor.updateImageMapAreasDimensions(imageMap, widthRatio, heightRatio);
            });
        });
    });
}

questionnaireEditor.setDisableImageMapInvalidCharactersRowEvent = function (context) {
    $(".v-areasTable .v-itemsBody .v-questionEditableItem .v-variableName", context).on("keypress", function (e) {
        return questionnaireEditor.disableInvalidCharacters(e);
    });
}

questionnaireEditor.setAddImageAreaChoice = function (context) {
    $(context).on("click", ".imageAreaSelectorEditorContainer .v-itemsContainer .h-addItemRow", function () {
        var container = $(this).closest(".v-questionEdit");
        var itemsContainer = $(this).closest(".v-itemsContainer");
        var itemIndex = $(".v-itemIndex:not(.deleted)", itemsContainer).length;
        $(".v-itemIndex:last:not(.deleted)", itemsContainer).text(itemIndex).show();
        questionnaireEditor.addNewImageMapArea(container, itemIndex);
    });
}

questionnaireEditor.setImageMapAreaEvents = function (imageMapArea) {
    imageMapArea.resizable({
        minWidth: 5,
        minHeight: 5,
        containment: "parent"
    }).draggable({
        containment: "parent",
        scroll: false,
        stack: ".v-area"
    });
}

questionnaireEditor.setDeleteImageAreaChoice = function (context) {
    $(context).on("click", ".imageAreaSelectorEditorContainer .v-choiceListEditor .v-questionEditableItem .h-deleteRow", function () {
        var container = $(this).closest(".v-questionEdit");
        var item = $(this).closest(".v-questionEditableItem");
        var itemIndex = $(".v-itemIndex", item).html();
        var imageMap = $(".v-imageMap", container);
        var imageMapArea = questionnaireEditor.getImageMapArea(itemIndex, imageMap);

        questionnaireEditor.replaceAreaIndexes(imageMapArea);

        imageMapArea.hide();
    });
}

// ---------------- Image Area Selector - Function ---------------------------------

questionnaireEditor.setImageAreaEvaluator = function (panel) {
    $(".v-questionPreview .imageMap", panel).each(function () {
        $(this).disableSelection();
        var imageMap = $(this);

        $(imageMap).imagesLoaded().always(function (instance) {
            $.each(instance.images, function (key, value) {
                var image = $(value.img);
                var width = image.width();
                var height = image.height();

                $(".area", imageMap).each(function () {
                    $(this).width(Math.min($(this).attr("data-width") * width, width));
                    $(this).height(Math.min($(this).attr("data-height") * height, height));
                    $(this).css("left", Math.ceil($(this).attr("data-left") * width));
                    $(this).css("top", Math.ceil($(this).attr("data-top") * height));

                    var selectedChoice = $(this).find(".choiceList select option:selected");
                    $(this).attr("title", selectedChoice.text().trim());
                    questionnaireEditor.updateImageMapAreaColor($(this));
                });
            });
        });
    });
}

// ---------------- Image Area Selector - Events ---------------------------------

questionnaireEditor.setImageAreaEvaluatorEvents = function (context) {

    $(context).on("mouseenter", ".v-editQuestionContent[data-qtypename='ImageAreaEvaluator'] .v-questionPreview .imageMap .area", function () {
        $(this).addClass("highlightedImageArea");
        questionnaireEditor.updateImageMapAreaColor($(this));
    });

    $(context).on("mouseleave", ".v-editQuestionContent[data-qtypename='ImageAreaEvaluator'] .v-questionPreview .imageMap .area", function () {
        $(this).removeClass("highlightedImageArea");
        questionnaireEditor.updateImageMapAreaColor($(this));
    });

    $(context).on("click", ".v-editQuestionContent[data-qtypename='ImageAreaEvaluator'] .v-questionPreview .imageMap .area", function () {
        var selectedChoice = $(this).find(".choiceList select option:selected");
        var nextChoice = selectedChoice.nextAll("option:not(:disabled)").first();

        if (nextChoice.length == 0) {
            nextChoice = $(this).find(".choiceList select option:first");
        }

        selectedChoice.prop("selected", false);
        nextChoice.prop("selected", true);
        $(this).attr("title", $.trim(nextChoice.text()));
        questionnaireEditor.updateImageMapAreaColor($(this));
    });
}

questionnaireEditor.updateImageMapAreaColor = function (area) {
    var color = area.find(".choiceList select option:selected").attr("data-color");

    if (!color && area.hasClass("highlightedImageArea")) {
        var imageMap = area.closest(".imageMap");
        color = imageMap.attr("data-highlightcolor");
    }

    if (color) {
        area.css("background-color", color);
    }
    else {
        area.css("background-color", "");
    }
}

// ---------------- Drag And Drop Ranking - Function ---------------------------------

questionnaireEditor.setDragDropRanking = function (_panel) {

    if ($(".dragDropList", _panel).sortable()) {
        $(".dragDropList", _panel).sortable("destroy");
    }

    $(".dragDropList", _panel).sortable({
        forcePlaceholderSize: true,
        forceHelperSize: true,
        cursor: "move",
        connectWith: ".dragDropList",
        tolerance: "pointer",
        placeholder: "dragDropHighlight",
        cancel: ".disabled",
        create: function (event, ui) {
            questionnaireEditor.setListInitialDimensions($(this));
        }
    }).disableSelection();

    $(".dragDropList", _panel).each(function () {
        $(this).sortable("option", "containment", $(this).closest(".dragDropRanking"));
    });

    $(".dragDropList", _panel).on("sortupdate", function (event, ui) {
        questionnaireEditor.updateValue($(this));
    });
}

questionnaireEditor.updateValue = function (list) {
    var container = list.closest(".dragDropRanking");
    var selectedAnswersList = $(".dragDropAnswerList", container);
    var selectedAnswers = $(".dragDropItem", selectedAnswersList);
    var maxAnswers = selectedAnswersList.attr("data-maxanswers");

    $(".dragDropChoiceList .dragDropItem", container).toggleClass("disabled", selectedAnswers.length >= maxAnswers);

    var value = selectedAnswers.map(function () {
        return $(this).attr("data-choicevalue");
    }).get().join();

    $(".dragDropValue", container).val(value).trigger("change");
}

questionnaireEditor.setListInitialDimensions = function (list) {
    var container = list.closest(".dragDropRanking");
    var numberOfCards = parseInt(list.attr("data-maxanswers"));
    if (!numberOfCards) {
        numberOfCards = $(".dragDropItem", container).length;
    }

    var card = $(".dragDropItem", container).first();

    if (container.hasClass("horizontal")) {
        list.width(card.outerWidth(true) * numberOfCards);
        list.height(card.outerHeight(true));
    }
    else {
        list.width(card.outerWidth(true));
        list.height((card.outerHeight() * numberOfCards) + (2 * (numberOfCards + 1)));
    }

    $(".dragDropItem .textDiv", list).each(function () {
        var top = (card.height() / 2) - ($(this).height() / 2);
        if (top > 0) {
            $(this).css("top", top + "px");
        }
    });
}

// ---------------- Slider - Event ---------------------------------

questionnaireEditor.setSliderVariableTypeEvent = function (context) {
    $(context).on("click", ".v-varType", function () {
        var parent = $(this).closest(".v-questionEdit");
        var defaultValue = $(".setting[data-name=DefaultValue]", parent);

        var answerRequiredOptions = $(".v-answerRequiredOptions", parent);
        var softPromptContainer = $(".v-softPromptContainer", answerRequiredOptions);
        var answerRequired = $(".h-answerRequired", answerRequiredOptions).val();
        var sliderType = $(this).val();

        if (sliderType == "0") { // Discrete slider
            defaultValue.removeClass("validateInt");
            $(".v-continuousVariableEditorContainer", parent).toggle(false);
            $(".v-choiceListEditorContainer", parent).toggle(true);

            if (answerRequired == "SoftPrompt")
                softPromptContainer.toggle(true);

            $(".v-qeRichEditText:visible", parent).a4richTextEditor({ library: true, piping: true, piping_system: true, inline: true, maxHeight: 150 });
        }
        else {
            defaultValue.addClass("validateInt");
            $(".v-continuousVariableEditorContainer", parent).toggle(true);
            $(".v-choiceListEditorContainer", parent).toggle(false);

            softPromptContainer.toggle(false);
        }

        $(".v-displayTicksPanel", parent).toggle($(".v-displayTicks", parent).is(":checked") && sliderType == "1");

        $("input.TypeValue", parent).val(sliderType);
    });
}

questionnaireEditor.setAddSliderStyleEvent = function (context) {
    $(context).on("click", ".v-sliderStyleEditor .v-addSliderStyle", function () {
        var container = $(this).closest(".v-sliderStyleEditor");
        var questionnaireId = 0;
        var questionId = 0;
        var styleId = 0;

        modalDialog.showWindow(questionnaireEditor.getUrl("AddSliderStyle", { questionId: 0, styleId: 0 }), 650, 750);
    });
}

questionnaireEditor.setEditSliderStyleEvent = function (context) {
    $(context).on("click", ".v-sliderStyleEditor .v-editSliderStyle", function () {
        var container = $(this).closest(".v-sliderStyleEditor");
        var query = "?StyleId=" + $(".v-sliderStyleSelector", container).val();
        var questionId = $(this).closest(".v-blockItemPanel").attr("id").replace("blockItemPanel", "");
        var styleId = $(".v-sliderStyleSelector", container).val();

        modalDialog.showWindow(questionnaireEditor.getUrl("AddSliderStyle", { questionId: questionId, styleId: styleId }), 690, 750);
    });
}

questionnaireEditor.setDeleteSliderStyleEvent = function (context) {
    $(context).on("click", ".v-sliderStyleEditor .v-deleteSliderStyle", function () {
        var container = $(this).closest(".v-sliderStyleEditor");
        var styleId = $(".v-sliderStyleSelector", container).val();

        modalDialog.showConfirmDialog(modalDialog.createDialogResources(sharedResources.DeleteItem, questionnaireEditor.resources.DeleteStyle, null, questionnaireEditor.resources.Delete),
            function () {
                a4.callServerMethod(questionnaireEditor.getUrl("DeleteSliderStyle"), { sliderStyleId: styleId },
                    function (result) {
                        $("select option[value=" + styleId + "]", container).remove();
                        questionnaireEditor.updateSliderStylePreviewPanel($("option:selected", container));
                    },
                    function () { }
                );
            }, 220, 500);
    });
}

// --------------- Slider - Functions ------------------------------------

questionnaireEditor.updateSliderStyle = function (sliderStyle) {
    a4.callServerMethod(questionnaireEditor.getUrl("UpdateSliderStyle"), { settings: sliderStyle },
        function (result) {
            var container = $(".v-questionEditorContainer .v-sliderStyleEditor:visible");
            var styleId = result;
            var sliderStyleSelector = $(".v-sliderStyleSelector", container);
            $("option", sliderStyleSelector).prop("selected", false);

            var option = $("option[value='" + styleId + "']", sliderStyleSelector);

            if (option.length == 0) {
                sliderStyleSelector.append("<option value='" + styleId + "'>" + sliderStyle.Name + "</option>");
                sliderStyleSelector.val(styleId);
                option = $("option[value='" + styleId + "']", sliderStyleSelector);
            }

            $.each(sliderStyle, function (key, value) {
                option.attr(key, value);
            });

            option.text(sliderStyle["Name"]);
            option.attr("cursorColor", sliderStyle["CursorColor"]);
            option.attr("cursorUrl", sliderStyle["CursorURL"]);
            option.attr("leftAnchorUrl", sliderStyle["LeftAnchorURL"]);
            option.attr("rightAnchorUrl", sliderStyle["RightAnchorURL"]);
            option.attr("sliderBarColor", sliderStyle["SliderBarColor"]);
            option.attr("sliderBarTrailingColor", sliderStyle["SliderBarTrailingColor"]);
            option.attr("sliderBarUrl", sliderStyle["SliderBarURL"]);
            option.prop("selected", true);

            questionnaireEditor.updateSliderStylePreviewPanel(option);
            modalDialog.close();
        },
        function (error) {
            modalDialog.close();
            var message = eval("(" + error.responseText + ")").Message;
            a4.showErrorMessage(message);
        }
    );
}

questionnaireEditor.setSliderDisplayTicksEvent = function (context) {
    $(context).on("click", ".v-displayTicks", function () {
        var parent = $(this).closest(".v-advanceSettings");
        $(".v-displayTicksPanel", parent).toggle($(this).is(":checked") && $(".TypeValue").val() == "1");
    });
}

questionnaireEditor.setSliderDisplayNoAnswerEvent = function (context) {
    $(context).on("click", ".v-displayNoAnswer", function () {
        var parent = $(this).closest(".v-advanceSettings");
        $(".v-noAnswerPanel", parent).toggle();
        $(".v-qeRichEditText:visible", parent).a4richTextEditor({ library: true, piping: true, piping_system: true, inline: true, maxHeight: 150 });
    });
}

questionnaireEditor.setSliderStyleChangeEvent = function (context) {
    $(context).on("change", ".v-sliderStyleEditor .v-sliderStyleSelector", function () {
        questionnaireEditor.updateSliderStylePreviewPanel($(this).find("option:selected"));
    });

    $(context).on("change", ".v-dimensionSelector[data-name=Height], .v-dimensionSelector[data-name=Width]", function () {
        questionnaireEditor.updateSliderStylePreviewPanel($(".v-sliderStyleSelector option:selected", context));
    });
}

questionnaireEditor.updateSliderStylePreviewPanel = function (selectedOption) {
    var container = selectedOption.closest(".v-sliderStyleEditor");
    var advancedOptions = container.closest(".v-questionEditorContainer").find(".v-advanceSettings");
    var sliderBar = $(".v-previewSliderBar", container);
    var trailingBar = $(".ui-slider-range", sliderBar);
    var cursorImage = $(".previewCursorImage", container);
    var sliderCursor = $(".v-sliderCursor", container);
    var sliderWidth = $(".v-setting[data-name=Width]", container).val();
    var sliderHeight = $(".v-setting[data-name=Height]", container).val();
    var cursorColor = selectedOption.attr("cursorcolor");
    var cursorUrl = selectedOption.attr("cursorurl");
    var sliderBarColor = selectedOption.attr("sliderbarcolor");
    var sliderBarTrailingColor = selectedOption.attr("sliderbartrailingcolor");
    var sliderBarUrl = selectedOption.attr("sliderbarurl");
    var leftAnchorUrl = selectedOption.attr("leftanchorurl");
    var rightAnchorUrl = selectedOption.attr("rightanchorurl");

    if (selectedOption.attr("editable") == "0") {
        $(".v-editSliderStyle", container).hide();
        $(".v-deleteSliderStyle", container).hide();
    }
    else {
        $(".v-editSliderStyle", container).show();
        $(".v-deleteSliderStyle", container).show();
    }

    //Slider Bar
    sliderBar.css("background", sliderBarColor ? sliderBarColor : "");

    if (sliderBarTrailingColor) {
        trailingBar.css("background", sliderBarTrailingColor);
        trailingBar.show();
    }
    else {
        trailingBar.hide();
    }

    if (sliderBarUrl && sliderBarUrl != "") {
        sliderBar.css("background-image", "url(" + sliderBarUrl + ")");
        sliderBar.css("border-width", "0px");
    }
    else {
        sliderBar.css("border-width", "1px");
    }

    if (sliderWidth && sliderWidth != "" && sliderWidth != "px") {
        sliderBar.css("width", sliderWidth);
    }
    else {
        sliderBar.css("width", "300px");
    }

    if (sliderHeight && sliderHeight != "" && sliderHeight != "px") {
        sliderBar.css("height", sliderHeight);
    }
    else {
        sliderBar.css("height", "12px");
    }

    var sliderBarHeight = sliderBar.height();

    //Slider Cursor
    sliderCursor.css("background", cursorColor ? cursorColor : "");

    if (cursorUrl && cursorUrl != "") {
        cursorImage = new Image();
        cursorImage.src = cursorUrl;

        var imageWidth = Math.min(cursorImage.naturalWidth > 0 ? cursorImage.naturalWidth : 16, 64);
        var imageHeight = Math.min(cursorImage.naturalHeight > 0 ? cursorImage.naturalHeight : 16, 64);

        var top = (sliderBarHeight / 2) - (imageHeight / 2);
        var topVal = Math.ceil(Math.abs(top)) * (top / Math.abs(top));

        sliderCursor.removeClass("ui-state-default");
        sliderCursor.css("background-image", "url(" + cursorUrl + ")");
        sliderCursor.css("background-repeat", "no-repeat");
        sliderCursor.css("border-width", "0px");
        sliderCursor.css("margin-left", "-" + imageWidth / 2 + "px");
        sliderCursor.css("margin-top", topVal + "px");
        sliderCursor.css("width", imageWidth + "px");
        sliderCursor.css("height", imageHeight + "px");
        sliderCursor.css("left", "80px");
    }
    else {
        sliderCursor.addClass("ui-state-default");
        sliderCursor.css("border-width", "");
        sliderCursor.css("margin-left", "");
        sliderCursor.css("margin-top", "");
        sliderCursor.css("width", "");
        sliderCursor.css("height", sliderBarHeight + 5 + "px");
        sliderCursor.css("left", "80px");
    }

    //Slider Anchors
    $('.leftAnchorImage', container).remove();
    $('.rightAnchorImage', container).remove();

    if (leftAnchorUrl != null && leftAnchorUrl != "") {
        sliderBar.before("<img src='" + leftAnchorUrl + "' class='leftAnchorImage' style='float:left;' />");
    }

    if (rightAnchorUrl != null && rightAnchorUrl != "") {
        sliderBar.after("<img src='" + rightAnchorUrl + "' class='rightAnchorImage' style='float:left;' />");
    }
}

questionnaireEditor.updateDimensionSelectorValue = function (selectors, forceUpdate) {
    $(selectors).each(function () {
        var value = $(this).val() || "";
        var dimensionVal = value.replace(/[^0-9\.]+/g, '') || '';

        if (!forceUpdate && dimensionVal == '')
            return true;

        var typeVal = value.replace(dimensionVal, '') || 'px';

        if (forceUpdate) {
            $(this).siblings(".v-dimensionSelector").attr("value", dimensionVal);
            $(this).siblings(".v-dimensionTypeSelector").attr("value", typeVal);
        }
        else {
            if (dimensionVal != $(this).siblings(".v-dimensionSelector").val()) {
                $(this).siblings(".v-dimensionSelector").val(dimensionVal);
            }

            if (typeVal != $(this).siblings(".v-dimensionTypeSelector").val()) {
                $(this).siblings(".v-dimensionTypeSelector").val(typeVal);
            }
        }
    });
}

questionnaireEditor.setDimensionSelector = function (context) {
    $(context).on("change", ".v-dimensionSelector", function () {
        questionnaireEditor.updateDimensionControl($(this));
    });

    $(context).on("change", ".v-dimensionTypeSelector", function () {
        questionnaireEditor.updateDimensionControl($(this));
    });
}

questionnaireEditor.updateDimensionControl = function (_item) {
    var _container = _item.parent(".v-dimensionSelectorContainer");
    var _dimensionVal = $(".v-dimensionSelector", _container).val();
    var _typeVal = $(".v-dimensionTypeSelector", _container).val();
    var _val = "";

    if (_dimensionVal != null && _dimensionVal != "" && _dimensionVal > 0) {
        _val = _dimensionVal + _typeVal;
    }

    $("input:hidden", _container).val(_val).trigger("change");
}

questionnaireEditor.setSliders = function (panel) {
    if ($(".sliderBar", panel).slider()) {
        $(".sliderBar", panel).slider("destroy");
    }

    $(".sliderBar", panel).each(function () {
        var sliderContent = $(this).closest(".sliderContents");
        var trailingColor = sliderContent.attr("data-trailingcolor");
        var cursorColor = sliderContent.attr("data-cursorcolor");
        var cursorImage = sliderContent.find(".cursorImage");

        if (trailingColor) {
            $(this).slider({ range: "min" });
            $(".ui-slider-range", sliderContent).css("background", trailingColor);
        }
        else {
            $(this).slider();
        }

        var sliderHandle = $(".ui-slider-handle", sliderContent);

        if (cursorImage.attr("src")) {
            sliderHandle.hide();
            questionnaireEditor.setSliderCursorImage($(this), sliderHandle, cursorImage);
        }
        else {
            if (cursorColor) {
                sliderHandle.css("background", cursorColor);
            }

            if (sliderContent.height() > 24) {
                sliderHandle.height(sliderContent.height() - (sliderHandle.position().top));
            }

            sliderHandle.hide();
            questionnaireEditor.createSlider($(this), sliderHandle);
        }
    });

    $(".sliderContainer", panel).each(function () {
        var gridItem = $(this).closest(".gridItem");
        var leftWidth = $(".sliderContentsRow .sliderLeft", gridItem).width();
        var rightWidth = $(".sliderContentsRow .sliderRight", gridItem).width();

        if (gridItem.length > 0 && (leftWidth == 0 || rightWidth == 0)) {
            gridItem.css("padding", "3px 15px");
        }
    });
}

questionnaireEditor.setSliderCursorImage = function (slider, sliderHandle, cursorImage) {
    cursorImage.hide();

    $(cursorImage).imagesLoaded(function () {
        var sliderContent = slider.closest(".sliderContents");
        var hideCursor = sliderContent.attr("data-hidecursor");
        cursorImage.show();
        var cursorHeight = cursorImage.height();
        var cursorWidth = cursorImage.width();
        cursorImage.hide();

        var cursorStyle = "background:url('" + cursorImage.attr("src") + "') no-repeat; width:" + cursorWidth + "px; height:" + cursorHeight + "px; border:0px; margin-left:-" + Math.floor(cursorWidth / 2) + "px; display:none;";
        sliderHandle.attr("style", cursorStyle);

        var sliderBarHeight = slider.height();
        var top = (sliderBarHeight / 2) - (cursorHeight / 2);
        var topVal = Math.ceil(Math.abs(top)) * (top / Math.abs(top));

        // Only set if we have a number
        if (!isNaN(topVal)) {
            sliderHandle.css("top", topVal + "px");
        }

        questionnaireEditor.createSlider(slider, sliderHandle);
    });
}

questionnaireEditor.createSlider = function (slider, sliderHandle) {
    var sliderContent = slider.closest(".sliderContents");
    var mainDiv = sliderContent.closest(".sliderContainer");
    var sliderValue = mainDiv.find('.sliderValue');
    var sliderCurrentValue = mainDiv.find('.sliderCurrentValue');
    var sliderType = sliderContent.attr("data-slidertype");
    var noAnswerCheckBox = mainDiv.find(".noAnswer");
    var hideCursor = sliderContent.attr("data-hidecursor");
    var followCursor = sliderCurrentValue.closest(".sliderCurrentValueFollow");

    sliderHandle.on("click", function () {
        if (noAnswerCheckBox != null && !noAnswerCheckBox.is(":checked")) {
            var selectedValue = slider.slider("value");
            slider.slider("value", selectedValue);
            if (sliderType == "Discrete") {
                sliderValue.val(sliderContent.attr("data-choicevalue" + selectedValue));
                sliderCurrentValue.html(questionnaireEditor.getCurrentValueHtml(sliderContent, selectedValue));
            }
            else {
                sliderValue.val(selectedValue);
                sliderCurrentValue.text(selectedValue);
            }
            sliderValue.trigger('change');
        }
    });

    slider.on("slide", function (event, ui) {
        if (hideCursor != "true") {
            sliderHandle.show();
        }

        if (sliderType == "Discrete") {
            sliderValue.val(sliderContent.attr("data-choicevalue" + ui.value));
            sliderCurrentValue.html(questionnaireEditor.getCurrentValueHtml(sliderContent, ui.value));
        }
        else {
            sliderValue.val(ui.value);
            sliderCurrentValue.text(ui.value);
        }

        if (followCursor) {
            var UpdateFollowCursorValue = function () {
                sliderHandle.show();
                var position = sliderHandle.offset();
                if (hideCursor) {
                    sliderHandle.hide();
                }

                if (followCursor.hasClass("followBottom")) {
                    position.left += (sliderHandle.width() / 2) - (followCursor.width() / 2);
                    position.top += sliderHandle.height() + 3;
                }
                else {
                    position.left += sliderHandle.width() + 10;
                    position.top += (sliderHandle.height() / 2) - (followCursor.height() / 2);
                }

                followCursor.offset(position);
            }

            setTimeout(UpdateFollowCursorValue, 10);
        }

        sliderValue.trigger("change");
    });

    noAnswerCheckBox.on("click", function () {
        if ($(this).is(":checked")) {
            sliderCurrentValue.html("");
            sliderValue.val($(this).val());
            slider.slider("disable");
        }
        else {
            sliderCurrentValue.html(questionnaireEditor.getCurrentValueHtml(sliderContent, slider.slider("value")));
            if (sliderType == "Discrete") {
                sliderValue.val(sliderContent.attr("data-choicevalue" + slider.slider("value")));
            }
            else {
                sliderValue.val(slider.slider("value"));
            }
            slider.slider("enable");
        }
        sliderValue.trigger("change");
    });

    // Set slider min and max values

    var minValue = Number(sliderContent.attr("data-minvalue"));
    var maxValue = Number(sliderContent.attr("data-maxvalue"));
    var defaultValue = Number(sliderContent.attr("data-defaultvalue"));

    slider.slider("option", "min", minValue);
    slider.slider("option", "max", maxValue);

    // Set slider initial value
    var value = sliderValue.val();

    if (value == null || value == "") {
        if (defaultValue >= minValue) {
            value = defaultValue;
        }
    }

    var cursorPosition = sliderContent.attr("data-cursorposition");

    if (value == null || value == "") {
        var hideCursor = sliderContent.attr("data-hidecursor");

        if (cursorPosition == "Middle") {
            slider.slider("value", (maxValue + minValue) / 2);
        }
        else if (cursorPosition == "Right") {
            slider.slider("value", maxValue);
        }
    }
    else {
        if (value == noAnswerCheckBox.val()) {
            noAnswerCheckBox.prop("checked", true);
            slider.slider("disable");
        }
        else {
            sliderValue.val(value);
            if (sliderType == "Discrete") {
                var sliderPosition = 0;

                for (sliderPosition = minValue; sliderPosition <= maxValue; sliderPosition++) {
                    if (sliderContent.attr("data-choicevalue" + sliderPosition) == value) {
                        break;
                    }
                }

                slider.slider("value", sliderPosition);
                sliderCurrentValue.html(questionnaireEditor.getCurrentValueHtml(sliderContent, sliderPosition));
            }
            else {
                slider.slider("value", value);
                sliderCurrentValue.text(value);
            }
        }
    }

    if (followCursor) {
        sliderHandle.show();
        var position = sliderHandle.offset();
        sliderHandle.hide();

        if (followCursor.hasClass("followBottom")) {
            position.left += (sliderHandle.width() / 2) - (followCursor.width() / 2);
            position.top += sliderHandle.height() + 3;
        }
        else {
            position.left += sliderHandle.width() + 10;
            position.top += (sliderHandle.height() / 2) - (followCursor.height() / 2);
        }

        followCursor.offset(position);
    }

    if (cursorPosition != "Hidden" && hideCursor != "true") {
        sliderHandle.show();
    }

    questionnaireEditor.setSliderDimensions(slider);
}

questionnaireEditor.setSliderDimensions = function (slider) {
    var sliderContent = slider.parents(".sliderContents");
    var mainDiv = sliderContent.parents(".sliderContainer");

    var leftWidth = $(".sliderContentsRow .sliderLeft", mainDiv).width();
    var rightWidth = $(".sliderContentsRow .sliderRight", mainDiv).width();
    var contentWidth = sliderContent.width();

    if (contentWidth < 10) {
        if (slider.parents('.gridItem').length > 0) {
            contentWidth = mainDiv.width() - leftWidth - rightWidth;

            if (contentWidth < 150) {
                contentWidth = 150;
                slider.parents('.gridItem').width(contentWidth + leftWidth + rightWidth);
            }

            sliderContent.width(contentWidth);
            $(".sliderContentsRow .sliderLeft", mainDiv).width(leftWidth);
            $(".sliderContentsRow .sliderRight", mainDiv).width(rightWidth);
        }
        else {
            slider.width(300);
            contentWidth = sliderContent.width();
        }
    }

    $(".sliderCurrentValueRow .sliderLeft", mainDiv).width(leftWidth);
    $(".sliderCurrentValueRow .sliderRight", mainDiv).width(rightWidth);
    $(".sliderCurrentValueRow .sliderCurrentValue", mainDiv).width(contentWidth);
}

questionnaireEditor.getCurrentValueHtml = function (sliderContent, value) {
    var html = "";

    if (sliderContent.attr("data-choiceimage" + value) != null && sliderContent.attr("data-choiceimage" + value) != "") {
        html += "<img src='" + sliderContent.attr("data-choiceimage" + value) + "'>"
    }

    if (sliderContent.attr("data-choicelabel" + value) != null && sliderContent.attr("data-choicelabel" + value) != "") {
        html += "<div>" + sliderContent.attr("data-choicelabel" + value) + "</div>";
    }

    return html;
}

// --------------- DATE ---------------------------------


// -------------------- Card Editor-----------------------------------


questionnaireEditor.setAddCardRowEvent = function (context) {
    $(context).on("click", ".v-cardListEditor .v-addPanel .h-addItemRow", function () {
        var container = $(this).closest(".v-questionEdit");
        var cardEditor = $(this).closest(".v-cardListEditor");

        var card = $(".v-newCard tbody tr", cardEditor).clone(false);
        var questionName = $(".v-questionName", container).val();
        var variableName = questionName.toUpperCase() + "_" + ($(".v-questionEditableItem:visible", cardEditor).length + 1);
        $(".v-cardName", card).val(variableName);
        $(card).appendTo($("table .v-cardListBody", cardEditor));

        $('.v-qeRichEditText:visible', card).a4richTextEditor({ library: true, piping: true, inline: true });
        cardEditor.trigger('rowAdded', card);

        $(this).scrollIntoView();

        a4ImageSelector.bindElements(card);
        a4.setColorPickers($(".v-cardColorColumn:not(.hidden) .v-colorPicker", card));
    });
}

questionnaireEditor.setEditCardLogicRowEvent = function (context) {
    $(context).on("click", ".v-cardListTable .h-editRowLogic", function () {
        var cardRow = $(this).closest(".v-questionEditableItem");
        var cardQuestion = $(this).closest(".v-cardListEditor");

        var hideLogic = cardRow.data("hideIf");
        questionnaireEditor.editCardHideLogic(cardQuestion, hideLogic, cardRow);
    });
}

questionnaireEditor.editCardHideLogic = function (cardQuestion, logic, cardRow) {
    var cardLogicEditor = $('.v-cardLogicEditor', cardQuestion).clone(true).show();
    var logicEditor = $('.v-logicEditor', cardLogicEditor);
    var content = $('<div id="EditCardLogicContainer">').append(logicEditor.outerHTML());

    var logicResources = {
        "Title": questionnaireEditor.resources.CardHideIf,
        "Message": content
    };

    modalDialog.showConfirmDialog(logicResources,
        function () {
            a4logicEditor.hasError = false;

            var oldId = (logic && logic.Id) || 0;
            var newLogic = a4logicEditor.getLogic(content, true);
            var hasLogic = (newLogic != null && (newLogic.Conditions.length > 0 || (newLogic.SyntaxType == "Advanced" && newLogic.CustomCondition.trim().length > 0)));

            newLogic.Id = oldId;

            if (!a4logicEditor.hasError) {
                cardRow.data("hideIf", newLogic);
            }

            if (hasLogic) {
                $(".h-editRowLogic", cardRow).removeClass("skip");
            }
            else {
                $(".h-editRowLogic", cardRow).addClass("skip");
            }
        }, 400, 600, null, null, {
        initFunction: function () {
            var logicEditor = $('#EditCardLogicContainer .v-logicEditor');
            a4logicEditor.updateVariables();
            a4logicEditor.editInlineTypeLogic(logicEditor, logic, questionnaireEditor.allowAdvanceLogic);
            a4logicEditor.editInlineConditionLogic(logicEditor, logic, questionnaireEditor.getInEditQuestion());
        }
    });
}

questionnaireEditor.disableCardsInvalidCharactersEvent = function (context) {
    $(context).on("keypress", ".v-cardListTable .v-questionEditableItem .v-cardName", function (e) { return DisableInvalidCharacters(e); });
    $(context).on("keypress", ".v-cardListTable .v-questionEditableItem input", function (e) { return DisableEnter(e); });
}

// --------------- DISABLED DATE ----------------------------

// --------------- MIN MAX ---------------------------------

questionnaireEditor.getValidatedMinMaxDateValue = function (value) {
    if (value.indexOf("[") == -1 && value.indexOf("]") == -1 && value.indexOf("$") == -1)
        return value;
    else
        return "";
}

questionnaireEditor.setMinMaxSelectorValues = function (itemPanel) {
    questionnaireEditor.setUseVariableWithAutoComplete(itemPanel);

    $(".v-minMaxValueContainer", itemPanel).each(function () {
        questionnaireEditor.setMinMaxInitialValue($(this));
    });
}

questionnaireEditor.setUseVariableWithAutoComplete = function (itemPanel) {
    // We set a use panel for getting the id in case we set the use variable for the grids
    var usePanel = (itemPanel.hasClass("v-blockItemPanel")) ? itemPanel : $(".v-blockItemPanel.inEdit", questionnaireEditor.container);
    var questionId = (usePanel.length > 0) ? questionnaireEditor.blockController.getBlockItemIdFromElement(usePanel) : 0;
    var typeVariables = _.map(_.reject(questionnaireEditor.variables, function (variable) { return variable.questionId == questionId }).sort(questionnaireEditor.sortVariables),
        function (variable) { return { value: variable.value, label: "[" + variable.name + "]", questionId: variable.questionId } });

    $(".v-useVariable .v-selectVariable", itemPanel).a4autocomplete({
        data: typeVariables,
        valueProperty: "value",
        labelProperty: "label",
        tooltipProperty: "questionId",
        tooltipData: function (autocomplete, tooltip, questionId) {
            a4.getTooltipQuestionText(autocomplete, tooltip, questionnaireEditor.Id, questionId);
        },
        change: function (event, ui) {
            $(this).closest(".v-minMaxValueContainer").find(".v-setting").val($(event.target).val());
        },
        select: function (event, ui) {
            if (typeof ui.item != "undefined")
                $(this).closest(".v-minMaxValueContainer").find(".v-setting").val(ui.item.label);
        }
    });
}

questionnaireEditor.setMinMaxInitialValue = function (editor) {
    if ($(".v-setting", editor).length > 0) {
        var value = $(".v-setting", editor).val();
        var minMaxSelectorValue = "";
        var enterValueDisplay = "none";
        var useVariableDisplay = "none";

        // hide TodayValue option if date type is not: DateTime, Date, Time
        var dateType = $(".v-dateType", editor.closest(".v-blockItemPanel")).val();

        if (typeof dateType != "undefined") {
            $(".v-minMaxSelector", editor).children("option[value^='TodayValue']").toggle(dateType == "DateTime" || dateType == "Date" || dateType == "Time");

            // validate TodayValue if user changed date type after model loading
            if (value == "TodayValue" && dateType != "DateTime" && dateType != "Date" && dateType != "Time") {
                $(".v-setting", editor).val("");
                value = "";
            }
        }

        if (value.indexOf("[") != -1 || value.indexOf("]") != -1 || value.indexOf("$") != -1) {
            minMaxSelectorValue = "UseVariable";
            useVariableDisplay = "inline-block";
            $(".v-useVariable input", editor).val(value);
        }
        else if (value == "TodayValue") {
            minMaxSelectorValue = "TodayValue";
        }
        else {
            minMaxSelectorValue = "EnterValue";
            enterValueDisplay = "inline-block";
            $(".v-enterValue input", editor).val(value);
        }

        $(".v-minMaxSelector", editor).val(minMaxSelectorValue);
        $(".v-enterValue", editor).css("display", enterValueDisplay);
        $(".v-useVariable", editor).css("display", useVariableDisplay);
    }
}

questionnaireEditor.setMinMaxValueChangeEvent = function (context) {
    $(context).on("change", ".v-minMaxValueContainer input[type=text].v-minMaxValue", function () {
        var parent = $(this).closest(".v-minMaxValueContainer");
        if ($(".v-minMaxSelector", parent).val().toUpperCase() != "USEVARIABLE") {
            $(".v-setting", parent).val($(this).val());
        }
    });
}

questionnaireEditor.setMinMaxSelectorChangeEvent = function (context) {
    $(context).on("change", ".v-minMaxSelector", function () {
        var parent = $(this).closest(".v-minMaxValueContainer");
        var enterValueDisplay = "none";
        var useVariableDisplay = "none";
        var selectedValue = $(this).val();
        var newMinMaxDate = "";

        $("input", parent).val("");

        if (selectedValue == "EnterValue") {
            enterValueDisplay = "inline-block";
        }
        else if (selectedValue == "UseVariable") {
            useVariableDisplay = "inline-block";
        }
        else if (selectedValue == "TodayValue") {
            $(".v-setting", parent).val(selectedValue);
            newMinMaxDate = questionnaireEditor.disabledDateControl.today();
        }

        if (parent.hasClass("h-MinValue") && questionnaireEditor.disabledDateControl)
            questionnaireEditor.disabledDateControl.updateMinDate(newMinMaxDate);
        else if (parent.hasClass("h-MaxValue") && questionnaireEditor.disabledDateControl)
            questionnaireEditor.disabledDateControl.updateMaxDate(newMinMaxDate);

        $(".v-enterValue", parent).css("display", enterValueDisplay);
        $(".v-useVariable", parent).css("display", useVariableDisplay);
    });
}

// --------------- Common controls - Functions ------------------------------------

questionnaireEditor.addNewItemRow = function (button) {
    var parent = button.closest(".v-itemsContainer");
    var item = parent.next(".v-newItem").html();
    $(item).insertBefore(button);
    var text = $(".v-itemText:last", parent);
    $(item).show();

    if (text.hasClass("editable")) {
        text.a4richTextEditor({ library: true, piping: true, inline: true });

        if (!questionnaireEditor.batchInsert) {
            text.trigger("click");
        }
    }
    else {
        text.trigger("focus");
    }

    if (!questionnaireEditor.batchInsert && parent.closest(".drilldownEditorContainer").length > 0) {
        questionnaireEditor.setNewDropdownRowId(parent);
    }
}

questionnaireEditor.setNewDropdownRowId = function (panel) {
    var newRow = $(".v-questionEditableItem:visible:last", panel);
    var last = $(".v-questionEditableItem", panel).eq(-2);  // Before last
    var lastId = (last.length > 0) ? parseInt($(".v-dropdownName", last).attr("id").replace("dropdownName", "")) + 1 : 1;
    $(".v-dropdownName", newRow).attr("id", "dropdownName" + lastId);
}

questionnaireEditor.setRandomizationPattern = function (context) {
    $(context).on("change", ".v-randomizationPattern", function () {
        questionnaireEditor.changeRandomizationPattern($(this));
    });

    $(context).on("change paste keyup cut select", ".v-groupByCountInput", function () {
        questionnaireEditor.changeRandomizationGroupCount($(this));
    });
}

questionnaireEditor.changeRandomizationPattern = function (element) {
    var container = element.closest(".v-randomizationOptions");
    var value = element.val();

    var isPatternGroupable = value == 1 || value == 2;
    $(".v-groupRandomizationByPattern", container).toggle(isPatternGroupable);

    var groupByCountInput = $(".v-groupByCountInput", container);
    groupByCountInput.val("");
    groupByCountInput.trigger("change");

    var groupByCountValue = groupByCountInput.val();
    var showRandomizationGroupPattern = groupByCountValue != null && groupByCountValue != "";
    $(".v-randomizationGroupPattern", container).toggle(isPatternGroupable && showRandomizationGroupPattern);
    $(".v-randomizationGroupPatternInput", container).val("0");

    $(".v-randomizationSynchWithQuestion", container).toggle(value == 3);
    $(".v-randomizationSynchQuestionValueId", container).val("");
    $(".v-randomizationSynchQuestionValueName", container).val("");
}

questionnaireEditor.changeRandomizationGroupCount = function (element) {
    var container = element.closest(".v-randomizationOptions");
    var value = element.val();

    var showRandomizationGroupPattern = value != null && value != "" && Number(value) > 1;
    $(".v-randomizationGroupPattern", container).toggle(showRandomizationGroupPattern);

    if (!showRandomizationGroupPattern) {
        $(".v-randomizationGroupPatternInput", container).val("0");
    }
}

questionnaireEditor.setRepeatHeaders = function (context) {
    $(context).on("change", ".v-repeatHeader", function () {
        var panel = $(this).closest(".v-repeatHeadersPanel");
        var checked = $(this).is(':checked');
        $(".v-repeatHeaderValue", panel).toggle(checked)

        if (!checked) {
            $(".v-setting", panel).val('')
        }
    });
}

questionnaireEditor.setRandomizationSynchronizeQuestionWithAutoComplete = function (context, questionId) {
    var data = questionnaireEditor.getQuestionsExceptSelf(questionId);
    var ac = $(".v-randomizationOptions .v-randomizationSynchQuestionValueName", context);

    if (ac.hasClass("autocomplete")) {
        ac.a4autocomplete("option", "data", data);
    }
    else {
        ac.a4autocomplete({
            data: data,
            valueProperty: "value",
            labelProperty: "name",
            tooltipProperty: "questionId",
            tooltipData: function (autocomplete, tooltip, questionId) {
                a4.getTooltipQuestionText(autocomplete, tooltip, questionnaireEditor.Id, questionId);
            },
            select: function (event, data) {
                var syncContainer = $(event.target).closest(".v-randomizationSynchWithQuestion");
                $(".v-randomizationSynchQuestionValueId", syncContainer).val(data.item.value);
            }
        });
    }
}

questionnaireEditor.setSoftPromptChoiceAutoComplete = function (context, questionId, questionType) {

    var answerRequiredOptions = $(".v-answerRequiredOptions", context);

    var choicesHidden = questionType == TEXT || questionType == DATE_TIME || questionType == EMAIL || questionType == OPENEND || questionType == NUMERIC_ANSWER;

    var isSoftPrompt = function (value) {
        return value == "SoftPrompt" || value == "UniquePrompt";
    };

    var toggleContainer = null;
    var softPromptContainer = $(".v-softPromptContainer", answerRequiredOptions);

    if (questionType != RESPONDENT_EMAIL && questionType != RESPONDENT_PHONE && questionType != RESPONDENT_LANGUAGE && questionType != RESPONDENT_TIMEZONE && questionType != STAR_RATING_GRID) {
        toggleContainer = function (answerRequiredValue) {
            var hasChoice = true;

            var container = softPromptContainer.closest(".v-blockItemPanel");
            var questionType = $(".v-questionEdit", container).attr("data-qtypename");

            if (questionType == SLIDER) {
                var sliderType = $(".v-varType:checked", container).val();
                hasChoice = sliderType != "1";
            }

            if (hasChoice && isSoftPrompt(answerRequiredValue)) {
                if (choicesHidden) {
                    var itemPanel = context.closest(".v-blockItemPanel");
                    questionnaireEditor.questionController.displayQuestionAdvanceSettings(itemPanel, true);
                    choicesHidden = false;
                }
                softPromptContainer.show();
            }
            else
                softPromptContainer.hide();
        };

        if (softPromptContainer.length > 0) {
            $(".h-answerRequired", answerRequiredOptions).on("change", function () {
                toggleContainer($(this).val());
            });
        }
    }
    else
        softPromptContainer.hide();

    if (!choicesHidden) {
        questionnaireEditor.setSelectMultipleChoicesWithAutoComplete(context, 0);
    }

    if (toggleContainer != null)
        toggleContainer($(".h-answerRequired", answerRequiredOptions).val());
}

questionnaireEditor.setSelectMultipleVariablesWithAutoComplete = function (editor, questionId, questionType = "unknown") {
    var data = questionnaireEditor.getVariableLabelsExceptQuestion(questionId);

    $(".v-selectMultipleVariables", editor).each(function () {
        $(this).a4autocomplete({
            data: data,
            multipleSelection: true,
            valueProperty: "name",
            labelProperty: "name",
            tooltipProperty: "questionId",
            tooltipData: function (autocomplete, tooltip, questionId) {
                a4.getTooltipQuestionText(autocomplete, tooltip, questionnaireEditor.Id, questionId);
            }
        });
    });

    if (questionType === "Carrousel") {
        var allVariableOfQuestionWithIndex = questionnaireEditor.getVariablesByQuestionId(questionId)
            .map((variable, index) => {
                var labelText = ++index + " - " + variable.name
                return { Code: index, Text: labelText }
            })

        $(".v-RowEliminationExcludedFields", editor).each(function () {
            $(this).a4autocomplete({
                data: allVariableOfQuestionWithIndex,
                multipleSelection: true,
                valueProperty: "Code",
                labelProperty: "Text"
            });
        });
    }
}

questionnaireEditor.setTextAnswerMultiLineEvent = function (context) {
    $(context).on("click", ".v-setting[data-name='MultiLine']", function () {
        var parent = $(this).closest(".v-advanceSettings");
        var checked = $(this).is(":checked");
        $(".v-linesPanel", parent).toggleClass("hidden", !checked);
    });
}

questionnaireEditor.setNumericAnswerNumberOfDecimalsEvent = function (context) {
    $(context).on("blur", ".v-numberOfDecimals", function () {
        var decimals = parseInt($(this).val());

        if (isNaN(decimals)) {
            decimals = 0;
        }

        $(".v-numericAnswerMinMaxValue", context).each(function () {
            $(this).autoNumeric("update", { mDec: decimals });
            // Trigger change so hidden setting input value is also updated with the new number of decimals
            $(this).trigger("change");
        });
    });
}

// --------------- General events ---------------------------------

questionnaireEditor.setRowEvents = function (context) {
    $(context).on("click", ".h-moveRowUp", function () {
        var item = $(this).closest(".v-questionEditableItem");
        questionnaireEditor.changeActiveRow(item);
        var previous = item.prevAll(".v-questionEditableItem:visible:first");

        if (previous.length > 0) {
            questionnaireEditor.swapIndexes(previous, item);
            item.insertBefore(previous);
            item.addClass("moved");    // Tag class used for cancel
        }
    });

    $(context).on("click", ".h-moveRowDown", function () {
        var item = $(this).closest(".v-questionEditableItem");
        questionnaireEditor.changeActiveRow(item);
        var next = item.nextAll(".v-questionEditableItem:visible:first");

        if (next.length > 0) {
            questionnaireEditor.swapIndexes(item, next);
            item.insertAfter(next);
            item.addClass("moved"); // Tag class used for cancel
        }
    });

    $(context).on("click", ".v-questionEditableItem .h-deleteRow", function () {
        var item = $(this).closest(".v-questionEditableItem");
        item.addClass("deleted").hide();
        questionnaireEditor.replaceItemIndexes(item);
    });
}

questionnaireEditor.setRowLogicEvent = function (context) {
    $(context).on("click", ".v-questionEditableItem .h-choiceLogic", function () {
        var listItem = $(this).closest("tr");
        var id = listItem.attr("id").replace("ChoiceRow", "");
        var choiceListEditor = listItem.closest(".v-choiceListEditor");
        var variable = choiceListEditor.attr("data-variables");
        var listId = questionnaireEditor.getVariableById(variable).choiceListId;

        if (listId) {
            $("tr.currentEditLogicItem", choiceListEditor).removeClass("currentEditLogicItem");
            listItem.addClass("currentEditLogicItem");
            var skipLogic = listItem.attr("data-choice-skipif");
            var dataSkip = (skipLogic && skipLogic !== undefined) ? skipLogic : "";
            var displayLogic = listItem.attr("data-choice-displayIf");
            var dataDisplay = (displayLogic && displayLogic !== undefined) ? displayLogic : "";
            modalDialog.showWindow(questionnaireEditor.getUrl("ChoiceSkipLogic", { choiceListId: listId, choiceId: id, skipLogic: dataSkip, displayLogic: dataDisplay }), 500, 850);
        }
    });
}

questionnaireEditor.updateChoiceSkipLogic = function (choiceId, skipLogic, displayLogic) {

    var choiceRow = $("#ChoiceRow" + choiceId);

    // If more than one row (when new rows with id 0 then use the class)
    if (choiceId == "0" || choiceRow.length > 1) {
        choiceRow = $("tr.currentEditLogicItem", choiceRow.closest(".v-choiceListEditor"));
    }

    choiceRow.attr("data-choice-skipif", JSON.stringify(skipLogic));
    choiceRow.attr("data-choice-displayif", JSON.stringify(displayLogic));

    hasLogic = ((skipLogic != null && (skipLogic.Conditions.length > 0 || (skipLogic.SyntaxType == "Advanced" && skipLogic.CustomCondition.trim().length > 0)))
        || (displayLogic != null && (displayLogic.Conditions.length > 0 || (displayLogic.SyntaxType == "Advanced" && displayLogic.CustomCondition.trim().length > 0))));

    var choiceLogicRowImg = $(".choice-logic span", choiceRow);
    if (hasLogic) {
        choiceLogicRowImg.removeClass("skip");
    }
    else {
        choiceLogicRowImg.addClass("skip");
    }
}

questionnaireEditor.setQuestionsRandomizationEditor = function (context) {
    if (!questionnaireEditor.isReadonly()) {
        //questionnaireEditor.setChangeRandomizationPatternEvent(context);
        questionnaireEditor.setAddQuestionsRandomizationRowEvent(context);
        questionnaireEditor.setDeleteQuestionsRandomizationRowEvent(context);
    }
}

questionnaireEditor.swapIndexes = function (item, next) {
    var itemIdx = $(".v-itemIndex", item).html();
    var nextIdx = $(".v-itemIndex", next).html();

    if (itemIdx && nextIdx) {
        $(".v-itemIndex", item).html(nextIdx);
        $(".v-itemIndex", next).html(itemIdx);
    }
}

questionnaireEditor.replaceItemIndexes = function (startItem, increaseStartItem) {
    // Replace order if item deleted
    var previousIndex = $(".v-itemIndex", startItem).html();

    // For cancel of delete
    if (increaseStartItem) {
        previousIndex++;
    }

    startItem.nextAll(".v-questionEditableItem:visible").each(function () {
        $(".v-itemIndex", $(this)).html(previousIndex);
        previousIndex++;
    });
}

questionnaireEditor.changeActiveRow = function (row) {
    var panel = row.closest("table");
    $("tr.selected", panel).removeClass("selected");
    row.addClass("selected");
}

// --------------- Randomization FUNCTIONS ------------------------------------


questionnaireEditor.setChangeRandomizationPatternEvent = function (patternDropDown) {
    var context = patternDropDown.closest(".v-questionEditableItem");

    var synchronizeWith = context.find(".synchronizeWith");
    var groupCount = context.find(".groupCount");
    var value = patternDropDown.val();
    var synchronizedLabel = questionnaireEditor.resources.RandomizationPatterns[3].Label;
    var permutationLabel = questionnaireEditor.resources.RandomizationPatterns[1].Label;
    var rotationLabel = questionnaireEditor.resources.RandomizationPatterns[2].Label;

    if (value == synchronizedLabel) {
        synchronizeWith.prop("disabled", false)
    }
    else {
        synchronizeWith.prop("disabled", true)
        synchronizeWith.val("");
    }

    if (value == permutationLabel || value == rotationLabel)
        groupCount.prop("disabled", false);
    else {
        groupCount.prop("disabled", true);
        groupCount.val("");
    }

    var editor = context.closest(".v-questionsRandomizationEditor");

    if ($(".hiddenStartPattern", editor).val() != value && (value == 3 || $(".hiddenStartPattern", editor).val() == 3)) {
        context.closest(".v-questionsRandomizationEditor").addClass("updated");
    }
    else {
        context.closest(".v-questionsRandomizationEditor").removeClass("updated");
    }
}

questionnaireEditor.setAddQuestionsRandomizationRowEvent = function (context) {
    $(context).on("click", ".v-questionsRandomizationEditor .v-addQuestionsRandomizationRow", function () {
        var editor = $(this).closest(".v-questionsRandomizationEditor");
        var rowId = $(".v-questionsRandomizationBody tr:visible", editor).size() + 1;
        var blockId = $(this).closest(".v-blockPanel").attr("id").replace("blockPanel", "");

        $('.v-questionsRandomizationTable', editor).show();

        var newItem = $(".v-newQuestionsRandomization .v-newItemBody tr", editor).clone();
        newItem.find(".v-itemIndex").html(rowId);
        newItem.removeClass("randomizationRow0");
        newItem.addClass("randomizationRow" + rowId);
        newItem.appendTo($("table .v-questionsRandomizationBody", editor));

        var startQuestionField = newItem.find(".h-startquestion-autocomplete");
        var endQuestionField = newItem.find(".h-endquestion-autocomplete");
        var randomizationField = newItem.find(".h-randomization-autocomplete");

        startQuestionField.a4autocomplete({
            valueProperty: "value",
            labelProperty: "name",
            tooltipProperty: "questionId",
            tooltipData: function (autocomplete, tooltip, questionId) {
                a4.getTooltipQuestionText(autocomplete, tooltip, questionnaireEditor.Id, questionId);
            },
            data: questionnaireEditor.getQuestionsByBlockId(blockId)
        });

        endQuestionField.a4autocomplete({
            valueProperty: "value",
            labelProperty: "name",
            tooltipProperty: "questionId",
            tooltipData: function (autocomplete, tooltip, questionId) {
                a4.getTooltipQuestionText(autocomplete, tooltip, questionnaireEditor.Id, questionId);
            },
            data: questionnaireEditor.getQuestionsByBlockId(blockId)
        });

        randomizationField.a4autocomplete({
            valueProperty: "Value",
            labelProperty: "Label",
            data: _.filter(questionnaireEditor.resources["RandomizationPatterns"], function (r) { return r.Value != null && r.Value != 4 && r.Value != 5; }),
            select: function (event, ui) {
                questionnaireEditor.setChangeRandomizationPatternEvent(randomizationField)
            }
        });

        $(".noRandomization", editor).hide();

        var blockId = questionnaireEditor.blockController.getBlockIdFromElement($(this));
        var blockQuestions = _.pluck(questionnaireEditor.getQuestionsByBlockId(blockId), "name");
        var newItem = $(".randomizationRow" + rowId + " .randomizationQuestion", editor);
        //SetSingleRandomizationQuestionAutoComplete(editor, newItem, blockId, blockQuestions);

        $(".randomizationRow" + rowId + " input", editor).on("keypress", function (e) { return DisableEnter(e); });
        // $(".randomizationRow" + rowId + " .synchronizeWith", editor).hide();

        questionnaireEditor.blockController.positionBlockMask();
        questionnaireEditor.blockController.updateSynchronizeWithValues(editor);
    });

    $(context).on("click", "input[type=checkbox].h-enable-looping", function () {
        var section = $(this).closest(".v-toggleContent");
        $('input[type=text].v-loopSize', section).prop('disabled', !$(this).is(':checked'));
        $('input[type=text].v-loopSize', section).val('1');
    });
}

questionnaireEditor.setDeleteQuestionsRandomizationRowEvent = function (context) {
    $(context).on("click", ".v-questionsRandomizationEditor .h-deleteRow", function () {
        var _editor = $(this).closest(".v-questionsRandomizationEditor");
        var _item = $(this).closest(".v-questionEditableItem");
        _item.addClass("deleted");
        _item.hide();

        questionnaireEditor.replaceItemIndexes(_item);
        questionnaireEditor.blockController.updateSynchronizeWithValues(_editor);

        if ($('.v-questionsRandomizationTable tbody tr:not(.deleted)', _editor).length == 0) {
            $('.v-questionsRandomizationTable', _editor).hide();
        }
    });
}



// --------------- Objects ------------------------------------

questionnaireEditor.choiceObject = function (choiceRow, questionType, forGrid) {
    var choice = new Object();
    var choiceTable = choiceRow.closest(".v-choiceListTable");

    choice.Id = $(choiceRow).attr("id").replace("ChoiceRow", "");
    choice.Value = choice.Code = $(choiceRow).find(".v-choiceCode").val();      // Json converter uses Value, Grid choices convertion needs Code. When GridQuestionManager update will use JsonConverters we can remove choice.Code
    choice.Text = $(choiceRow).find(".v-choiceText").a4richTextEditor("getContent") || '';
    choice.ParentValue = $(".v-choiceParent", choiceRow).val();

    var choiceOpenEndType = $(choiceRow).find('.v-choiceOpenEndType');
    choice.OpenEndType = choiceOpenEndType.is(":checkbox") ? (choiceOpenEndType.is(":checked") ? "1" : "0") : choiceOpenEndType.val();
    choice.OpenEndWidth = $(choiceRow).find('.v-choiceOpenEndWidth').val();
    choice.OpenEndHeight = $(choiceRow).find('.v-choiceOpenEndHeight').val();
    choice.OpenEndSize = $(choiceRow).find('.v-choiceOpenEndSize').val();
    choice.OpenEndLines = $(choiceRow).find('.v-choiceOpenEndLines').val();
    choice.OpenEndMaxLength = $(choiceRow).find('.v-choiceOpenEndMaxLength').val();
    choice.OpenEndMinLength = $(choiceRow).find('.v-choiceOpenEndMinLength').val();
    choice.OpenEndDisplayWhenSelected = $(choiceRow).find('.v-choiceOpenEndDisplayWhenSelected').val();
    choice.EnforceOpenEnd = $(choiceRow).find('.v-choiceEnforceOpenEnd').val();

    choice.Default = $(choiceRow).find('.v-defaultChoice:checkbox').is(":checked");
    choice.Visible = $(choiceRow).find('.v-visibleChoice:checkbox').is(":checked");
    choice.Fixed = $(choiceRow).find('.v-fixedChoice:checkbox').is(":checked");
    choice.Exclusive = $(choiceRow).find('.v-exclusiveChoice:checkbox').is(":checked");
    choice.Header = $(choiceRow).find('.v-headerChoice:checkbox').is(":checked");
    choice.Settings = {};

    //Choice settings
    $(choiceRow).find(".v-choiceSetting[data-settingname]:visible").each(function () {
        choice.Settings[$(this).attr("data-settingname")] = $(this).val();
    });

    choice.TranslatableChoiceSettings = {};

    //Choice translatable settings
    $(choiceRow).find(".v-translatableChoiceSetting[data-settingname]:visible").each(function () {
        choice.TranslatableChoiceSettings[$(this).attr("data-settingname")] = $(this).val();
    });

    if (questionType == IMAGE_AREA_SELECTOR) {
        var itemIndex = $(".v-itemIndex", choiceRow).html();
        questionnaireEditor.setImageMapAreaPositions(itemIndex, choiceRow, choice.Settings);
    }

    choice.VariableId = ($(choiceRow).attr("data-variable") || "").replace("dropdownName", "");

    if (forGrid) {
        choice.SkipLogicJSON = $(choiceRow).attr("data-choice-skipif");
        choice.DisplayLogicJSON = $(choiceRow).attr("data-choice-displayif");
    }
    else {
        choice.SkipLogic = $(choiceRow).attr("data-choice-skipif");
        choice.DisplayLogic = $(choiceRow).attr("data-choice-displayif");
    }

    return choice;
}

questionnaireEditor.cardObject = function (row) {
    var card = new Object();

    card.Id = $(row).attr("id").replace("VariableRow", "");
    card.Name = $(row).find(".v-cardName").val();
    card.Text = $(row).find(".v-cardLabel").a4richTextEditor("getContent") || '';
    card.Group = $(row).find(".v-cardGroupLabel").a4richTextEditor("getContent") || '';
    card.Color = $(row).find(".v-colorPickerValue").val();
    card.ImageUrl = $(row).find(".v-cardImageUrl").val();
    card.HideIf = $(row).data("hideIf");
    card.New = false;

    if (card.HideIf == "") {
        card.HideIf = null;
    }

    if (!card.ImageUrl) {
        card.ImageUrl = null;
    }

    return (card.Name == "") ? null : card;
}

questionnaireEditor.dropdownObject = function (dropdownRow) {
    var dropdown = new Object();

    dropdown.Id = $(".v-dropdownName", dropdownRow).attr("id").replace("dropdownName", "");
    dropdown.Name = $(".v-dropdownName", dropdownRow).val();
    dropdown.Text = $(".v-dropdownText", dropdownRow).a4richTextEditor("getContent") || '';
    dropdown.Width = $(".v-dropdownWidth", dropdownRow).val();
    dropdown.Height = $(".v-dropdownHeight", dropdownRow).val();
    dropdown.MinAnswers = $(".v-dropdownMin", dropdownRow).val();
    dropdown.MaxAnswers = $(".v-dropdownMax", dropdownRow).val();
    dropdown.Pattern = $(".v-dropdownPattern", dropdownRow).val();
    dropdown.PatternGroupCount = $(".v-dropdownPatternColumns", dropdownRow).val();
    dropdown.PatternSyncWith = $(".v-dropdownPatternSync", dropdownRow).val();
    dropdown.EliminateIf = $(".v-dropdownEliminateIf", dropdownRow).val();
    dropdown.EliminateIfNot = $(".v-dropdownEliminateIfNot", dropdownRow).val();
    dropdown.SharedListId = $(".v-dropdownChoiceListId", dropdownRow).val();
    dropdown.New = false;

    return (dropdown.Name != '') ? dropdown : null;
}

questionnaireEditor.randomizationObject = function (row) {
    var editor = row.closest('.v-questionsRandomizationEditor');
    var index = row.find(".v-itemIndex").text();
    var item = new Object();

    if (!questionnaireEditor.errorOnRequest) {
        if (row.hasClass("deleted")) {
            item.Id = row.attr("id").replace("RandomizationRow", "");
            item.Id = 0 - item.Id;
        }
        else {
            var startQuestionVal = $(".h-startquestion-autocomplete", row).val();
            var endQuestionVal = $(".h-endquestion-autocomplete", row).val();

            if (!startQuestionVal) {
                a4.showErrorMessage(questionnaireEditor.resources.RandomizeStartQuestionError.replace("{0}", "#" + index));
                questionnaireEditor.errorOnRequest = true;
            }
            else if (!endQuestionVal) {
                a4.showErrorMessage(questionnaireEditor.resources.RandomizeEndQuestionError.replace("{0}", "#" + index));
                questionnaireEditor.errorOnRequest = true;
            }
            else {
                item.Id = row.attr("id").replace("RandomizationRow", "");
                item.StartQuestionId = questionnaireEditor.getQuestionByName(startQuestionVal).value;
                item.EndQuestionId = questionnaireEditor.getQuestionByName(endQuestionVal).value;
                item.RandomizationPatternType = questionnaireEditor.getPatternIdByName($(".h-randomization-autocomplete", row).val());
                item.SynchronizeWithId = row.find(".synchronizeWith option:selected").text();
                item.GroupCount = row.find(".groupCount").val();
            }
        }
    }

    return item;
}

questionnaireEditor.imageMapAreaObject = function (areaRow) {
    var areaObject = new Object();

    areaObject.Id = $(areaRow).attr("id").replace("VariableRow", "");
    areaObject.VariableName = $(areaRow).find(".v-variableName").val().toUpperCase();
    areaObject.Name = $(areaRow).find(".v-variableName").val();
    areaObject.Text = $(areaRow).find(".v-areaText").a4richTextEditor("getContent") || '';

    if (areaObject.VariableName == "") {
        questionnaireEditor.errorOnRequest = true;
        a4.showErrorMessage(questionnaireEditor.resources.VariableNameRequired);
        $(areaRow).find(".v-variableName").trigger("focus");
    }

    var itemIndex = $(".v-itemIndex", areaRow).html();
    questionnaireEditor.setImageMapAreaPositions(itemIndex, areaRow, areaObject);

    return areaObject;
}


questionnaireEditor.systemChoiceObject = function (choiceRow) {
    var choice = new Object();

    choice.Id = $(choiceRow).attr("id").replace("ChoiceRow", "");
    choice.Value = choice.Code = $(choiceRow).find(".v-choiceCode").val();
    choice.Text = $(choiceRow).find(".v-choiceText").a4richTextEditor("getContent") || '';

    choice.Default = false;
    choice.Visible = $(choiceRow).find('.v-visibleChoice:checkbox').is(":checked");
    choice.Fixed = $(choiceRow).find('.v-fixedChoice:checkbox').is(":checked");
    choice.Exclusive = false;

    if (choice.Code == "") {
        return null;
    }

    return choice;
}

questionnaireEditor.lookupColumnObject = function (row) {
    var column = new Object();

    column.Id = $(row).attr("id").replace("ColumnRow", "");
    column.Name = $(row).find(".v-columName").val().trim();
    column.ColumnName = $(row).find(".v-columnDbName").val();
    column.Text = $(row).find(".v-columnTitle").a4richTextEditor("getContent") || '';
    column.Visible = $(row).find(".v-columnVisible").is(":checked");
    column.Searchable = $(row).find(".v-columnSearchable").is(":checked");
    column.Width = $(row).find(".v-columnWidth").val();

    return (column.Name == "") ? null : column;
}

questionnaireEditor.actionUpdateObject = function (actionId, actionType, properties, executionCondition) {
    var item = new Object();
    item.Id = actionId;
    item.Action = actionType;
    item.Properties = properties;
    item.ExecutionCondition = executionCondition;
    return item;
}

questionnaireEditor.categoryObject = function (row) {
    var category = new Object();

    category.Id = $(row).attr("id").replace("VariableRow", "");
    category.Name = $(row).find(".v-highlightCategoryName").val();
    category.Text = $(row).find(".v-highlightCategoryLabel").a4richTextEditor("getContent") || '';
    category.Color = $(row).find(".v-colorPickerValue").val();
    category.Visible = $(row).find(".v-highlightCategoryVisible:checkbox").prop("checked").toString();
    category.HideIf = $(row).data("hideIf");
    category.New = false;

    if (category.HideIf == "") {
        category.HideIf = null;
    }

    if (category.Visible == "") {
        category.Visible = "true";
    }

    return (category.Name == "") ? null : category;
}

questionnaireEditor.texthighlightChoiceObject = function (tokenChoice) {
    var choice = new Object();
    choice.Id = 0;
    choice.Value = $(tokenChoice).attr("mappedchoiceCode");
    choice.Text = $(tokenChoice).text();
    choice.ParentValue = "";
    choice.OpenEndType = 1;
    choice.OpenEndWidth = "";
    choice.OpenEndHeight = "";
    choice.OpenEndSize = "";
    choice.OpenEndLines = "";
    choice.OpenEndMaxLength = "";
    choice.OpenEndMinLength = "";
    choice.OpenEndDisplayWhenSelected = "";
    choice.EnforceOpenEnd = true;
    choice.Default = false;
    choice.Visible = true;
    choice.Fixed = false;
    choice.Exclusive = false;

    choice.Settings = {};
    choice.Settings['Highlightable'] = $(tokenChoice).attr("highlightable");
    choice.Settings['IsGroup'] = $(tokenChoice).attr("isgroup");
    choice.TranslatableChoiceSettings = {};
    choice.SkipLogic = null;
    choice.DisplayLogic = null;

    return choice;
}

// --------------- Question Type specific FUNCTIONS ------------------------------------

// Question types
var AUTO_COMPLETE = "AutoComplete";
var CARD_SORT = "CardSort";
var CHOICE_GRID = "ChoiceGrid";
var CHECKBOX = "CheckBox";
var RADIO_BUTTON = "RadioButton";
var TEXT = "TextAnswer";
var EMAIL = "EmailAddressAnswer";
var OPENEND = "OpenEndAnswer";
var DATE_TIME = "DateTimeAnswer";
var DRAG_DROP_RANKING = "DragDropRanking";
var DRILLDOWN = "DrillDown";
var HYBRID_GRID = "HybridGrid";
var IMAGE_AREA_EVALUATOR = "ImageAreaEvaluator";
var IMAGE_AREA_SELECTOR = "ImageAreaSelector";
var IMAGE_CHOICE_GRID = "ImageChoiceGrid";
var IMAGE_SELECTOR = "ImageSelector";
var LOOKUP_TABLE = "LookupTable";
var NUMERIC_ANSWER = "NumericAnswer";
var RUNNING_TOTAL = "RunningTotal";
var SLIDER = "Slider";
var STAR_RATING_GRID = "StarRatingGrid";
var NET_PROMOTER_GRID = "NetPromoter";
var TIMER = "Timer";
var RESPONDENT_EMAIL = "RespondentEmail";
var RESPONDENT_PHONE = "RespondentPhone";
var RESPONDENT_LANGUAGE = "RespondentLanguage";
var RESPONDENT_TIMEZONE = "RespondentTimeZone";
var SIGNATURE = "Signature";
var TEXT_HIGHLIGHTER = "TextHighlighter";
var HEAT_MAP = "HeatMap";
var CARROUSEL = "Carrousel";

$(document).on('click', 'input[id^="topicSettings"]', function () {
    var isChecked = $(this).is(':checked')
    if (isChecked) {
        $(this).closest(".sentiment-config").children('#sentimentSettingOption').prop('disabled', true);
        $(this).closest(".sentiment-config").children('#sentimentSettingOption').addClass('v-setting checked');
        $(this).closest(".sentiment-config").children('#sentimentSettingOption').val(true);
        $(this).closest(".sentiment-config").children('#sentimentSettingOption').prop('checked', true);
    } else {
        $(this).closest(".sentiment-config").children('#sentimentSettingOption').prop('disabled', false);
    }
});

questionnaireEditor.setQuestionAdvanceOptionsByType = function (parent, itemPanel, questionType) {
    switch (questionType) {
        case CARD_SORT:
        case DRAG_DROP_RANKING:
        case SIGNATURE:
        case CARROUSEL:
            a4.setColorPickers($(".v-colorPicker"));
            break;

        case DATE_TIME_ANSWER:
            questionnaireEditor.setMinMaxSelectorValues(itemPanel);
            questionnaireEditor.setDateType($(".v-dateType", parent), false);
            questionnaireEditor.setDisableDateControl("#" + parent.closest('.block-item-panel').attr('id'));

            questionnaireEditor.registerDateFormatChangeEvent(itemPanel, parent);
            questionnaireEditor.registerTimeFormatChangeEvent(itemPanel);
            questionnaireEditor.toggleDisabledDatesControl($(".v-dateType", parent).val());
            break;

        case IMAGE_AREA_SELECTOR:
        case IMAGE_AREA_EVALUATOR:
        case HEAT_MAP:
            a4.setColorPickers($(".v-colorPicker"));
            $(parent).on("change", ".v-setting[data-name=Height], .v-setting[data-name=Width]", function () {
                questionnaireEditor.updateImageMapDimensions(itemPanel);
            });
            break;

        case LOOKUP_TABLE:
            questionnaireEditor.initializeLookTableAdvanceEditor(itemPanel);
            break;

        case SLIDER:
            questionnaireEditor.updateSliderStylePreviewPanel($(".v-sliderStyleSelector option:selected", parent));
            break;

        case TIMER:
            questionnaireEditor.initializeTimeAdvanceEditor(itemPanel);
            break;

        case CHECKBOX:
        case RADIO_BUTTON:
            if (questionnaireEditor.useS2) {
                $(parent).on("change", ".v-setting[data-name=DisplayOrder]", function () {
                    var numberOfColumns = $(".v-setting[data-name=NumberOfColumns]", parent);
                    numberOfColumns.val("");

                    var displayOrderValue = $(this).val();
                    var numberOfColumnsContainer = numberOfColumns.closest(".ui-control-container");
                    numberOfColumnsContainer.toggle(displayOrderValue == "Vertical");
                });
            }
            break;
        case TEXT_HIGHLIGHTER:
            questionnaireEditor.initializeTextHighlighterAdvanceEditor(itemPanel);
            a4.setColorPickers($(".v-colorPicker"));
            break;
    }
}

questionnaireEditor.setQuestionOptionsByType = function (parent, itemPanel, questionType) {
    switch (questionType) {
        case OPENEND:
            questionnaireEditor.initializeOpenEndEditor(itemPanel);
        case CARD_SORT:
            questionnaireEditor.initializeCardEditor(itemPanel);
            break;
        case CARROUSEL:
            questionnaireEditor.initializeCardEditor(itemPanel);
            questionnaireEditor.initializeChoiceListAnswerTypeEditor(itemPanel);
            break;

        case DRILLDOWN:
            //questionnaireEditor.setDropdownsSelect(itemPanel);
            break;

        case IMAGE_AREA_SELECTOR:
        case IMAGE_AREA_EVALUATOR:
            questionnaireEditor.initializeImageMapEditor(itemPanel);
            a4ImageSelector.bindElements(itemPanel);
            break;
        case HEAT_MAP:
            questionnaireEditor.initializeImageMapEditor(itemPanel);
            a4ImageSelector.bindHeatMapElement(itemPanel);
            break;
        case LOOKUP_TABLE:
            questionnaireEditor.initializeLookTableEditor(itemPanel);
            break;

        case NUMERIC_ANSWER:
        case SLIDER:
            questionnaireEditor.setMinMaxSelectorValues(itemPanel);
            questionnaireEditor.updateSliderStylePreviewPanel($(".v-sliderStyleSelector option:selected", parent));
            a4ImageSelector.bindElements(itemPanel);
            break;
        case TEXT_HIGHLIGHTER:
            questionnaireEditor.initializeTextHighlighterCategoriesEvents(itemPanel);
            questionnaireEditor.initializeTextHighlighterTokensEvents(itemPanel)
            questionnaireEditor.setTextHighlighterStopwordsEvents(itemPanel);
            break;
    }
}


questionnaireEditor.setDisplayQuestionTypePreview = function (panel, questionType, isSettingSaveAction = false) {
    switch (questionType) {
        case AUTO_COMPLETE:
            questionnaireEditor.setAutoComplete(panel);
            break;

        case CARD_SORT:
            questionnaireEditor.setCardSort(panel);
            break;

        case CARROUSEL:
            questionnaireEditor.updateCarouselAllStatementDimensions(panel);
            //Reset already saved carousel preview value on saved action in preview
            if (isSettingSaveAction) {
                questionnaireEditor.ResetStatementSelectionForCarousel(panel);
            }
            break;

        case CHOICE_GRID:
            questionnaireEditor.setChoiceGrid(panel);
            questionnaireEditor.setGridRowHoverEvent(panel);
            //questionnaireEditor.setGridColumnWidths(panel);
            break;

        case DRAG_DROP_RANKING:
            questionnaireEditor.setDragDropRanking(panel);
            break;

        case DRILLDOWN:
            questionnaireEditor.setDrilldownPreview(panel);
            break;

        case HYBRID_GRID:
            questionnaireEditor.setSliders(panel);
            questionnaireEditor.setStarRating(panel);
            questionnaireEditor.setImageSelectors(panel);
            questionnaireEditor.setImageSelectorHoverEvent(panel);
            questionnaireEditor.setGridRowHoverEvent(panel);
            //questionnaireEditor.setGridColumnWidths(panel);
            break;

        case IMAGE_SELECTOR:
            questionnaireEditor.setImageSelectors(panel);
            questionnaireEditor.setImageSelectorHoverEvent(panel);
            questionnaireEditor.setImageSelectorClickEvent(panel);
            break;

        case IMAGE_AREA_SELECTOR:
            questionnaireEditor.setImageAreaSelector(panel);
            questionnaireEditor.setImageAreaSelectorEvents(panel);
            break;

        case IMAGE_AREA_EVALUATOR:
            questionnaireEditor.setImageAreaEvaluator(panel);
            break;

        case NUMERIC_RANKING:
            questionnaireEditor.adjustNumericRankingTextWidth(panel);
            break;

        case IMAGE_CHOICE_GRID:
            questionnaireEditor.setImageSelectors(panel);
            questionnaireEditor.setGridRowHoverEvent(panel);
            questionnaireEditor.setImageSelectorHoverEvent(panel);
            break;

        case LOOKUP_TABLE:
            questionnaireEditor.setLookupTablePreview(panel);
            break;

        case NUMERIC_ANSWER:
            questionnaireEditor.setNumericAnswer(panel);
            break;

        case RUNNING_TOTAL:
            questionnaireEditor.setNumericAnswer(panel);
            questionnaireEditor.setGridRowHoverEvent(panel);
            //questionnaireEditor.setGridColumnWidths(panel);
            break;

        case SLIDER:
            questionnaireEditor.setSliders(panel);
            break;

        case STAR_RATING_GRID:
            questionnaireEditor.setStarRating(panel);
            questionnaireEditor.setGridRowHoverEvent(panel);
            //questionnaireEditor.setGridColumnWidths(panel);
            break;
    }

    var $choiceList = $(".choiceList, .numericRanking, .dragDropRanking, .cardSortContent", panel);
    var $choiceListGrid = $(".choiceGrid, .hybridGrid, .imageChoiceGrid, .starRatingGrid,  .netPromoter, .runningTotal", panel);
    var $gridLogic = $(".gridLogic", panel);

    if ($choiceList) {
        $(".hideif,.displayif", $choiceList).each(function () {
            var item = $(this);
            if (item.parent().children("span").length == 0) {
                item.before("<span class='fa fa-eye RowCheck'></span>");
            }
        });

        $(".variableif", $choiceList).each(function () {
            var item = $(this);
            if (item.parent()[0].className == "cardGroup" &&
                item.parent().parent().children("span").length == 0) {
                item.parent().before("<span class='fa fa-eye RowCheck'></span>");
            }
        });
    }

    if ($choiceListGrid) {
        $(".hideif,.displayif", $choiceListGrid).each(function () {
            var item = $(this);
            var idNumber = parseInt(item.attr("id") == undefined ? 0 : item.attr("id").match(/\d+/g).map(Number)[0]);
            var childernLength = item.children("td,th").first().children("span#" + idNumber).length;

            if (item.is("tr") && childernLength == 0 && this.id.toLowerCase().indexOf("openend") == -1) {
                item.children("td,th").first().prepend("<span class='fa fa-eye rowTd' id ='" + idNumber + "'></span>");//left of row
            }
        });

        $("[class*='variableif']", $choiceListGrid).each(function () {
            var item = $(this);

            if ($("tr#" + item.attr('id') + "_alt").length > 0) {
                $("tr#" + item.attr('id') + "_alt").remove();
            }
            var rowCloned = item.clone();
            $("td,th", rowCloned).html("");
            rowCloned.attr('id', rowCloned.attr('id') + "_alt");
            rowCloned.attr('class', 'gridRow_alt');
            item.before(rowCloned);

            _.each(this.classList, function (element) {
                if (element.indexOf('variableif') > -1) {
                    var dataColumnPosition = element.match(/\d+/g).map(Number)[0];
                    var tdElement = $("td[data-column-position=" + dataColumnPosition + "]", rowCloned);
                    var itemInSameColumn = $("[data-column-position=" + dataColumnPosition + "]", rowCloned.closest("div.preview-content"));
                    var $widthAdjustElement = $(".sliderContainer, .starRating", tdElement);
                    if (tdElement.children("span.fa-eye").length == 0) {
                        tdElement.prepend("<span class='fa fa-eye dsadadsa'></span>");
                        if ($widthAdjustElement.length > 0) {
                            $widthAdjustElement.closest("td").css({ "min-width": $widthAdjustElement[0].clientWidth + 25 });//20 is span width

                        }

                    }
                }
            });
        });
    }

    if ($gridLogic) {
        $gridLogic.children(".hideif").each(function () {
            var item = $(this);
            var dataColumnPosition = item.attr("data-column-position");
            var dataChoicePosition = item.attr("data-choice-position");
            if (parseInt(dataColumnPosition) == 0 && dataChoicePosition != null) {
                var $thElement = $("th[data-choice-position=" + dataChoicePosition + "] ", panel);
                if ($thElement.children("span").length == 0)
                    $thElement.prepend("<span class='fa fa-eye test '></span>");
            }
            else {
                var $thElement = $("th[data-column-position=" + dataColumnPosition + "] ", panel);
                if ($thElement.children("span.fa-eye").length == 0) {
                    $thElement.first().prepend("<span class='fa fa-eye'></span>");
                }
            }
        });
    }
}


questionnaireEditor.isGridQuestionType = function (type) {
    return type === HYBRID_GRID || type === CHOICE_GRID || type === RUNNING_TOTAL || type === IMAGE_CHOICE_GRID
        || type === STAR_RATING_GRID || type === NET_PROMOTER_GRID;
}

questionnaireEditor.getLastCodeForImportChoices = function (button) {
    var editPanel = button.closest('.v-itemsContainer');
    var choiceIndex = $("table .v-choiceListBody .v-questionEditableItem:visible", editPanel).length;
    return questionnaireEditor.getLastChoiceCode(editPanel, choiceIndex);

    var frame = $("iframe").contents();
    $("#lastCode", frame).val(lastCode);
}

questionnaireEditor.setImportChoicesEvent = function (context) {
    $(context).on("click", ".h-importChoices", function () {
        var importButton = $(this);
        var lastCode = questionnaireEditor.getLastCodeForImportChoices(importButton);
        modalDialog.showWindow(questionnaireEditor.getUrl("ImportChoices", { lastCode: lastCode }), 350, 600);
    });
}

function setImportedChoices(data, overwrite) {
    var newChoices = $.parseJSON(data);
    var editQuestion = questionnaireEditor.getInEditQuestion();
    var existingChoices = $(".v-choiceListBody .v-questionEditableItem:visible", editQuestion).length;
    var importButton = $(".h-importChoices", editQuestion);
    var editPanel = importButton.closest('.v-itemsContainer');

    if (overwrite) {
        existingChoices = 0;

        _.each($(".v-questionEditableItem", editPanel), function (item) {
            $(item).addClass("deleted").hide();
            questionnaireEditor.replaceItemIndexes($(item));
        });
    }

    if ((_.size(newChoices) + existingChoices) <= questionnaireEditor.choiceListMaxRowCount) {
        var addButton = importButton.siblings(".h-addItemRow");
        questionnaireEditor.addMultipleItems(newChoices, null, editPanel, addButton, true);
    }
    else {
        var choiceListEditor = editPanel.closest(".v-choiceListEditor");
        var variable = choiceListEditor.attr("data-variables");
        var listId = questionnaireEditor.getVariableById(variable).choiceListId;
        var choices = [];
        var pos = 1;

        if (!overwrite) {
            _.each($(".v-choiceListBody .v-questionEditableItem:visible", choiceListEditor), function (item) {
                var id = $(item).attr("id").replace("ChoiceRow", "");
                var oeTypeEnum = $('.v-choiceOpenEndType', item).val();
                var oeType = (oeTypeEnum == "None" ? 0 : oeTypeEnum == "Below" ? 1 : 2);
                var settings = [];

                //Choice settings
                $(item).find(".v-choiceSetting[data-settingname]:visible").each(function () {
                    settings.push({ "Name": $(this).attr("data-settingname"), "Value": $(this).val() });
                });

                choices.push({
                    "Id": id, "ChoiceListId": listId, "Code": $(".v-choiceCode", item).val(), "Text": $(".v-choiceText", item).a4richTextEditor("getContent"), "Visible": true,
                    "Fixed": $('.v-fixedChoice:checkbox', item).is(":checked"), "Header": false, "ParentValue": "", "Position": pos++, "Deleted": false, "Edited": true,
                    "Exclusive": $('.v-exclusiveChoice:checkbox', item).is(":checked"), "Default": $('.v-defaultChoice:checkbox', item).is(":checked"), "Settings": settings,
                    "OpenEndType": oeType, "OpenEndTypeEnum": oeTypeEnum, "OpenEndWidth": $('.v-choiceOpenEndWidth', item).val(), "OpenEndHeight": $('.v-choiceOpenEndHeight', item).val(),
                    "OpenEndSize": $('.v-choiceOpenEndSize', item).val(), "OpenEndLines": $('.v-choiceOpenEndLines', item).val(),
                    "OpenEndMaxLength": $('.v-choiceOpenEndMaxLength', item).val(), "OpenEndMinLength": $('.v-choiceOpenEndMinLength', item).val(),
                    "OpenEndDisplayWhenSelected": $('.v-choiceOpenEndDisplayWhenSelected', item).val()
                });
            });
        }

        _.each($(".v-choiceListBody .v-questionEditableItem.deleted", choiceListEditor), function (item) {
            var id = $(item).attr("id").replace("ChoiceRow", "");
            choices.push({ "Id": id, "ChoiceListId": listId, "Code": "", "Text": "", "Visible": true, "Default": false, "Exclusive": false, "Fixed": false, "Header": false, "ParentValue": "", "Position": 1, "Deleted": true, "Edited": false });
        });

        _.each(newChoices, function (item) {
            choices.push({ "Id": 0, "ChoiceListId": listId, "Code": item.Value, "Text": item.Label, "Visible": true, "Default": false, "Exclusive": false, "Fixed": false, "Header": false, "ParentValue": "", "Position": pos++, "Deleted": false, "Edited": false });
        });

        var callback = function (newChoiceList) {
            questionnaireEditor.setChoiceListChoices(listId, choices);
        }

        questionnaireEditor.switchChoiceEditorToLargeList(editQuestion, choiceListEditor, callback);
    }
}

questionnaireEditor.setAddMultipleItemsEvent = function (context) {
    $(context).on("click", ".h-addMultipleRows", function () {
        var addButton = $(this).prev(".h-addItemRow");
        var editPanel = $(this).closest('.v-itemsContainer');
        var choices = $(".v-choiceListTable", editPanel).length > 0;
        var startRows = $(".v-questionEditableItem:visible", editPanel);

        questionnaireEditor.showAddMultipleDialog(context, startRows, choices, function (items) {
            editPanel.addClass("addingMultipleItems");
            questionnaireEditor.addMultipleItems(items, startRows, editPanel, addButton, false);
            editPanel.removeClass("addingMultipleItems");
        });
    });
}

questionnaireEditor.addMultipleItems = function (items, startRows, editPanel, addButton, isImport) {
    var i = 0;
    var itemCounts = 0;
    var row = null;
    var empty = null;
    var existingChoiceValues = [];
    var editingChoices = addButton.closest(".imageAreaSelectorEditorContainer").length == 0
        && addButton.closest(".v-dropdownsContainer").length == 0
        && addButton.closest(".v-choiceListEditor").length > 0;

    var addItemFn = function () {
        if (!editingChoices)
            addButton.trigger("click");
        else
            questionnaireEditor.addChoiceRow(addButton);
    };

    questionnaireEditor.batchInsert = true;
    questionnaireEditor.batchInsertCode = 0;

    if (editingChoices || isImport) {
        _.each($(".v-questionEditableItem:not(.deleted)", editPanel), function (item) {
            existingChoiceValues.push($(item).find(".v-choiceCode").val());
        });
    }

    $.each(items, function (index, item) {
        empty = ((item.Value == null || item.Value == "") && item.Label == "");

        if (isImport && existingChoiceValues.length > 0 && !empty && _.contains(existingChoiceValues, item.Value)) {
            return true;
        }

        if (item && (!empty || (startRows && itemCounts <= startRows.length))) {    // newly created empty rows are disregarded
            itemCounts++;

            if (empty) {
                startRows.eq(i++).addClass("deleted").hide();
            }
            else {
                if (editingChoices && item.Value !== null) {
                    while (startRows && startRows.length > i && existingChoiceValues.length > i &&
                        existingChoiceValues[i] !== item.Value && _.contains(existingChoiceValues, item.Value)) {
                        // Existing choice code at current position was deleted
                        startRows.eq(i++).addClass("deleted").hide();
                    }
                }

                if (startRows && startRows.length > i && (!editingChoices || item.Value === null ||
                    (existingChoiceValues.length > i && existingChoiceValues[i] === item.Value))) {
                    // Existing choice code at current position
                    row = startRows.eq(i++);
                }
                else {
                    addItemFn();
                    row = $(".v-questionEditableItem:last", editPanel);

                    if (editingChoices && startRows) {
                        // New choice code at current position
                        var current = startRows.eq(i);
                        row.insertBefore(current);
                    }
                }

                var name = $(".v-itemName", row);
                var text = $(".v-itemText", row);
                var prevValue = text.attr("data-prev");

                if (name.length > 0 && item.Value) {
                    name.val(RemoveHtml(item.Value).replace(/[^a-zA-Z0-9_.-]/g, ''));
                }

                if (text.length > 0) {
                    if (item.Label.indexOf('<') != -1) {
                        item.Label = a4.closeHtmlTags(item.Label);
                    }

                    if (text.hasClass("rich-text-editor")) {
                        text.a4richTextEditor("setContent", item.Label);
                    }
                    else {
                        text.text(item.Label); // Set text as a4richTextEditor will decode HTML
                        text.a4richTextEditor({ library: true, piping: true, inline: true });
                    }

                    text.attr("style", "");
                    text.attr("data-changed", "true");
                    text.attr("data-prev", prevValue);
                }
            }
        }
    });

    questionnaireEditor.batchInsert = false;
    questionnaireEditor.batchInsertCode = 0;

    while (startRows && i < startRows.length) {
        startRows.eq(i++).addClass("deleted").hide();
    }
}


questionnaireEditor.setAddLinkedItemsEvent = function (context) {
    $(context).on("click", ".h-addLinkedRows", function () {
        var editPanel = $(this).closest('.v-itemsContainer');
        questionnaireEditor.showAddMultipleDialog(context, null, false,
            function (items) {
                questionnaireEditor.addLinkedItems(items, editPanel);
            },
            questionnaireEditor.resources.MessageAddLinkedAnswersInstruction
        );
    });
}

questionnaireEditor.setImportLinkedChoicesEvent = function (context) {
    $(context).on("click", ".h-importLinkedItems", function () {
        modalDialog.showWindow(questionnaireEditor.getUrl("ImportLinkedChoices"), 350, 600);
    });
}

questionnaireEditor.initItemsBeforeAddingLinkedItems = function (dropdowns) {
    var calls = [];

    for (var i = 0; i != dropdowns.length; i++) {
        var row = $(dropdowns[i]);

        if (!row.data("choices")) {
            calls.push(questionnaireEditor.loadLargeListChoices(row.attr("data-listId"), null, true));
        }
    }

    return calls;
}

questionnaireEditor.addLinkedItems = function (inputItems, editPanel) {
    var drilldownContainer = editPanel.closest(".v-drilldownEditorContainer");
    var dropdowns = $(".v-dropdownTable .v-questionEditableItem:visible", drilldownContainer);

    $.when.apply($, questionnaireEditor.initItemsBeforeAddingLinkedItems(dropdowns)).then(
        function () {
            questionnaireEditor.addNewLinkedItems(dropdowns, inputItems);
        }
    );
}

questionnaireEditor.addNewLinkedItems = function (dropdowns, inputItems) {
    $.each(dropdowns, function (index, item) {
        var dd = $(item);
        var dropdownChoices = dd.data("choices");

        var maxChoice = (!dropdownChoices) ? 1 : parseInt(_.max(dropdownChoices, function (c) { return isNaN(c.Code) ? 0 : parseInt(c.Code); }).Code) + 1;
        dd.data("nextCode", maxChoice);

        var maxPosition = (!dropdownChoices) ? 1 : parseInt(_.max(dropdownChoices, function (c) { return parseInt(c.Position); }).Position) + 1;
        dd.data("nextPosition", maxPosition);

        if (!dropdownChoices)
            dd.data("choices", []);
    });

    $.each(inputItems, function (index, inputLine) {
        var values = inputLine.Label.split(',');
        var previousCode = "";
        var newIndex;

        if (values.length == dropdowns.length) {
            for (var i = 0; i != values.length; i++) {
                var dd = $(dropdowns[i]);
                var dropdownChoices = dd.data("choices");
                var text = $.trim(values[i]);
                var choice = _.find(dropdownChoices, function (c) {
                    return $.trim(c.Text) == text;
                });

                if (choice && i != (values.length - 1)) {
                    previousCode = choice.Code;
                }
                else {
                    var code = dd.data("nextCode");
                    var position = dd.data("nextPosition");
                    dropdownChoices.push({ "Id": 0, "ChoiceListId": dd.attr("data-listId"), "Code": code, "Text": text, "ParentValue": previousCode, "Default": false, "Exclusive": false, "Visible": true, "Fixed": false, "Position": position, "Deleted": false, "Edited": false, "Header": false });
                    dd.data("nextCode", code + 1);
                    dd.data("nextPosition", position + 1);
                    previousCode = code;
                }
            }
        }
    });
}

questionnaireEditor.setImportedLinkedItems = function (data) {
    var newItems = $.parseJSON(data);
    var importButton = $(".h-importLinkedItems", questionnaireEditor.getInEditQuestion());
    questionnaireEditor.addLinkedItems(newItems, importButton);
}

// --------------- Modal Popups ------------------------------------


questionnaireEditor.showAddMultipleDialog = function (owner, startRows, choices, saveFunction, message) {
    var instruction = $("<div class='instruction'>" + ((message) ? message : choices ? questionnaireEditor.resources.Message_AddMultipleAnswerInstructionManually : questionnaireEditor.resources.Message_AddMultipleAnswerInstructionNamesManually) + '</div>');
    var h = 425;    //($(window).height() / 2.2);
    var w = 670;    //Math.min(($(window).width() / 2), 800);
    var textarea = $('<textarea style="height:' + h + 'px; max-height:12em; width:' + w + 'px; max-width:600px; margin-top:15px;"></textarea>');
    var addingNewQuestion = $(".newQuestion", questionnaireEditor.container).length > 0;
    var chooseAddMethodDiv = null;
    var label = null;
    var labelManually = null;
    var labelAutomatically = null;
    var textareaValue = "";

    if (startRows != null) {
        startRows.each(function (i, e) {
            var name = $(".v-itemName", e);
            var text = $(".v-itemText", e);
            var textContent = questionnaireEditor.getItemValue(text);
            // The textContent value is coming from a rich editor field, so HTML can be trusted
            label = name.val() + "," + textContent;

            if (textareaValue != "")
                textareaValue += "\n";

            textareaValue += label;
        });

        textarea.append(textareaValue);

        labelManually = choices ? questionnaireEditor.resources.Message_AddMultipleAnswerManuallyAssignCodes : questionnaireEditor.resources.Message_AddMultipleAnswerManuallyAssignNames;
        labelAutomatically = choices ? questionnaireEditor.resources.Message_AddMultipleAnswerAutomaticallyAssignCodes : questionnaireEditor.resources.Message_AddMultipleAnswerAutomaticallyAssignNames;
        chooseAddMethodDiv = $("<div>" + (choices ? questionnaireEditor.resources.Message_AddMultipleAnswerSelectInstruction : questionnaireEditor.resources.Message_AddMultipleAnswerSelectInstructionNames) + "</div><div style='padding: 10px 0;'><input type='radio' name='choices' id='choices' checked='checked' value='UpdateValuesManually' class='updateValuesManually' /><label for='UpdateValues'>" + labelManually + "<label> <input type='radio' name='choices'  id='choices' value='UpdateValuesAutomatically' class='updateValues' /><label for='UpdateValues'>" + labelAutomatically + "<label></div>");
    }

    var content = $('<div id="AddMultipleDialogContainer">').append(chooseAddMethodDiv).append(instruction).append(textarea);

    var addMultipleResources = {
        "Title": questionnaireEditor.resources.AddEditMultiple,
        "Message": content
    };

    $("#choices[value=UpdateValuesManually]", content).on("click", function () {
        $(".instruction", content).html(choices ? questionnaireEditor.resources.Message_AddMultipleAnswerInstructionManually : questionnaireEditor.resources.Message_AddMultipleAnswerInstructionNamesManually);
    });

    $("#choices[value=UpdateValuesAutomatically]", content).on("click", function () {
        $(".instruction", content).html(choices ? questionnaireEditor.resources.Message_AddMultipleAnswerInstructionAutomatically : questionnaireEditor.resources.Message_AddMultipleAnswerInstructionNamesAutomatically);
    });

    var yesFunction = function () {
        var withValues = chooseAddMethodDiv != null ? $(".updateValues", content).is(":checked") : false;

        var newRows = _.compact(_.map($('textarea', content).val().split('\n'),
            function (label) { return questionnaireEditor.extractEditMultipleValueAndText(chooseAddMethodDiv, withValues, label); }));

        if (questionnaireEditor.editMultipleTranslationDesync(startRows, newRows)) {
            var editor = startRows.first().closest(".v-choiceListEditor");
            $(".v-desyncTitle", editor).show();
        }

        saveFunction(newRows);
    }

    // If open frame then open add multiple from frame
    var parentFrame = getParentFrame();

    if (parentFrame && parentFrame.showAddMultipleDialog) {
        parentFrame.showAddMultipleDialog(addMultipleResources, yesFunction, h, w);
    }
    else {
        modalDialog.showConfirmDialog(addMultipleResources, yesFunction, h, w);
    }
}

questionnaireEditor.extractEditMultipleValueAndText = function (multiItems, includeValues, item) {
    var a = {};
    var value = null;
    var label = item.trim();

    if (multiItems && !includeValues) {
        var i = item.indexOf(",");

        if (i != -1) {
            value = item.substring(0, i);
            label = item.substring(i + 1);
        }
        else {
            value = label;
            label = "";
        }
    }

    a.Value = value;
    a.Label = label;
    return a;
}

questionnaireEditor.editMultipleTranslationDesync = function (startRows, newRows) {
    var initialSize = (startRows) ? startRows.length : 0;
    var hasDesync = (questionnaireEditor.languages.length > 1 && initialSize > newRows.length - 1);

    if (!hasDesync && questionnaireEditor.languages.length > 1) {
        for (var i = 0; !hasDesync && i < initialSize; i++) {
            var text = $(".itemText", startRows.eq(i));
            hasDesync = (text.val() != newRows[i].Label);
        }
    }

    return hasDesync;
}

// --------------- DRILLDOWN --------------------------------------

questionnaireEditor.setEditDropdownChoices = function (context) {
    $(context).on("click", ".v-dropdownsContainer .h-editDropdownChoices", function () {
        var listItem = $(this).closest("tr");
        var choiceListId = listItem.attr("data-listId");

        if (choiceListId) {
            var load = listItem.data("choices") === undefined;
            var shared = $(".v-dropdownSharedQuestionName", listItem).val();

            modalDialog.showWindow(questionnaireEditor.getUrl("ChoiceListTable", { choiceListId: choiceListId, load: load, shared: shared }), 700, 850);
        }
        else {
            a4.callServerMethod(questionnaireEditor.getUrl("CreateChoiceList"), {},
                function (result) {
                    listItem.attr("data-listId", result);
                    $(".v-dropdownChoiceListId", listItem).val(result);

                    modalDialog.showWindow(questionnaireEditor.getUrl("ChoiceListTable", { choiceListId: result }), 700, 850);
                });
        }
    });
}


questionnaireEditor.setAddDropdownRowEvent = function (context) {
    $(context).on("click", ".v-drilldownEditor .h-addDropdown", function (event) {
        var editor = $(this).closest(".v-drilldownEditor");
        var dropdown = $(".v-newDropdown tbody tr", editor).clone(false);
        var lastRow = $(".v-dropdownTable .v-questionEditableItem:visible:last", editor);
        var lastIndex = (lastRow.length > 0) ? parseInt($(".v-itemIndex", lastRow).text()) : 0;

        if (!isNaN(lastIndex)) {
            $(".v-itemIndex", dropdown).text(lastIndex + 1);
        }

        var lastDrop = (lastRow.length > 0) ? $(".v-dropdownName", lastRow) : $(".v-dropdownTable .v-questionEditableItem:last", editor).find(".v-dropdownName");
        var lastId = parseInt(lastDrop.attr("id").replace("dropdownName", "")) + 1;
        $(".v-dropdownName", dropdown).attr("id", "dropdownName" + lastId)
        $(dropdown).appendTo($("table .v-dropdownListBody", editor));
        $('.v-qeRichEditText:visible', dropdown).a4richTextEditor({ library: true, piping: true, inline: true });
        $(".v-dropdownName", dropdown).focus();

        if (questionnaireEditor.batchInsert) {
            var value = ($(".v-itemIndex", lastRow).length > 0) ? $(".v-itemIndex", lastRow).text() : lastRow.prevAll(".v-questionEditableItem:visible").length + 1;
            $(".v-dropdownName", dropdown).val(value);
        }

        lastRow = $(".v-dropdownTable .v-questionEditableItem:visible:last", editor);
        a4.callServerMethod(questionnaireEditor.getUrl("CreateChoiceList"), {},
            function (result) {
                lastRow.attr("data-listId", result);
                $(".v-dropdownChoiceListId", lastRow).val(result);
            });
    });
}

questionnaireEditor.setEditDrillDownDropdown = function (context) {
    $(context).on("keypress", ".v-drilldownEditor input.v-dropdownName", function (e) { return DisableInvalidCharacters(e); });

    $(context).on("focusout", ".v-drilldownEditor input.v-dropdownName", function () {
        var choicesPanel = $(this).closest(".v-drilldownEditorContainer").find(".v-choiceListEditor");
        var value = $(this).val().trim().replace(/\s/g, '_');
        $(this).val(value);

        var id = $(this).attr("id");
        var dropdownsPanel = $(this).closest(".v-itemsContainer");

        if (value == "") {
            var row = $(this).closest(".v-questionEditableItem");
            value = $(".v-itemIndex", row).length > 0 ? $(".v-itemIndex", row).text() : row.prevAll(".v-questionEditableItem:visible").length + 1;
            var name = $(".v-questionName", questionnaireEditor.getInEditQuestion()).val() + "_" + value;
            $(this).val(name);
        }
    });
}

questionnaireEditor.initEditDropdown = function (frame, variableId) {
    var question = questionnaireEditor.getInEditQuestion();
    var questionId = questionnaireEditor.blockController.getBlockItemIdFromElement(question);
    var dropdown = $("#dropdownName" + variableId, question);
    var row = dropdown.closest(".v-questionEditableItem");

    var content = $(frame).contents();

    var randomizationVal = $(".v-dropdownPattern", row).val();
    $(".v-randomizationPattern option:selected", content).removeAttr("selected");
    $(".v-randomizationPattern option[value='" + randomizationVal + "']", content).attr("selected", "selected");

    $(".v-randomizationPattern", content).val(randomizationVal);
    questionnaireEditor.setRandomizationPattern(content);
    questionnaireEditor.changeRandomizationPattern($(".v-randomizationPattern", content));

    $(".v-groupRandomizationByPattern input", content).val($(".v-dropdownPatternColumns", row).val());
    $(".v-eliminateIf input", content).attr("data-value", $(".v-dropdownEliminateIf", row).val());
    $(".v-eliminateIfNot input", content).attr("data-value", $(".v-dropdownEliminateIfNot", row).val());

    var syncWithId = $(".v-dropdownPatternSync", row).val()

    if (syncWithId && syncWithId != "") {
        var name = questionnaireEditor.getQuestionById(syncWithId).name;
        $(".v-randomizationSynchWithQuestion .v-randomizationSynchQuestionValueName", content).val(name);
        $(".v-randomizationSynchWithQuestion .v-randomizationSynchQuestionValueId", content).val(syncWithId);
    }

    questionnaireEditor.setRandomizationSynchronizeQuestionWithAutoComplete(content, questionId);
    questionnaireEditor.setSelectMultipleVariablesWithAutoComplete(content);
    questionnaireEditor.setSelectMultipleChoicesWithAutoComplete(content);

    $(".v-selectQuestion", content).val($(".v-dropdownSharedQuestionName", row).val()).attr("data-value", $(".v-dropdownChoiceListId", row).val());
    $(".v-stopUsingChoices", content).toggle($(".v-selectQuestion", content).val() != "");
    questionnaireEditor.setSelectQuestionForChoicesEvent($(".v-useSameAsPanel", content), false, questionId);
    questionnaireEditor.setStopUsingChoicesEvent(content);
}

questionnaireEditor.saveEditDropdown = function (frame, variableId) {
    var question = questionnaireEditor.getInEditQuestion();
    var dropdown = $("#dropdownName" + variableId, question);
    var row = dropdown.closest(".v-questionEditableItem");

    var content = $(frame).contents();
    $(".v-dropdownPattern", row).val($(".v-randomizationPattern", content).val());
    $(".v-dropdownPatternColumns", row).val($(".v-groupRandomizationByPattern input", content).val());
    $(".v-dropdownPatternSync", row).val($(".v-randomizationSynchWithQuestion .v-randomizationSynchQuestionValueId", content).val());
    $(".v-dropdownEliminateIf", row).val($(".v-eliminateIf .selected-item", content).map(function () { return $(this).attr("data-value"); }).get());
    $(".v-dropdownEliminateIfNot", row).val($(".v-eliminateIfNot .selected-item", content).map(function () { return $(this).attr("data-value"); }).get());
    var sharedQuestion = $(".v-selectQuestion", content);
    $(".v-dropdownChoiceListId", row).val(sharedQuestion.val() ? sharedQuestion.attr("data-value") : null);

    if (!sharedQuestion.val()) {
        row.data("choices", []);
    }
    else {
        questionnaireEditor.loadLargeListChoices(sharedQuestion.attr("data-value"), row.attr("data-listId"), true);
    }

    $(".v-dropdownSharedQuestionName", row).val(sharedQuestion.val());
    return modalDialog.close();
}


questionnaireEditor.setEditDropdownOptions = function (context) {
    $(context).on("click", ".v-drilldownEditor .h-editDropdownOptions", function () {
        var row = $(this).closest(".v-questionEditableItem");
        var variableId = $(".v-dropdownName", row).attr("id").replace("dropdownName", "")
        modalDialog.showWindow(questionnaireEditor.getUrl("DropdownOptionsEditor", { variableId: variableId }), 500, 750);
    });
}


questionnaireEditor.setDrilldownPreview = function (panel) {
    $("select", panel).each(function () {
        if ($(this).attr("multiple")) {
            $(this).find("option[value!='']").each(function () {
                if ($(this).css("display") == "none") {
                    $(this).remove();
                }
            });
        }
    });
}

// --------------- NUMERIC ---------------------------------

questionnaireEditor.setNumericAnswer = function (panel) {
    $("input.numericAnswer", panel).autoNumeric();
}


// --------------- IMAGE SELECTOR ---------------------------------

questionnaireEditor.setImageSelectors = function (panel) {
    $(".imageChoice .choice :checkbox", panel).hide();
}

questionnaireEditor.setImageSelectorHoverEvent = function (panel) {
    var choice = $(".imageChoice .choice", panel).first();
    var zoom = choice.attr("data-zoom");
    var imageWidth = choice.width();
    var imageHeight = choice.height();
    var hoveredCss = {};
    var unhoveredCss = {};

    if (zoom != undefined && zoom != "" && zoom > 0) {
        zoom = 1 + (zoom / 100);
        var zoomedWidth = imageWidth * zoom;
        var zoomedHeight = imageHeight * zoom;
        var marginTop = -(((zoomedHeight - imageHeight) / 2) + 5);
        var marginLeft = -(((zoomedWidth - imageWidth) / 2) + 5);
        var zoomedImageHtml = '<img class="zoomedImage highlightedImageChoice" style="position: absolute; width:' + zoomedWidth + 'px; height:' + zoomedHeight + 'px; z-index: 10 ; margin-top:' + marginTop + 'px; margin-left:' + marginLeft + 'px; background-color:#FFFFFF;">';
    }
    else {
        zoom = undefined;
    }

    panel.on("mouseenter", ".imageChoice .choice:not(.disabled)", function () {
        var choiceImage = $(this).find(".choiceImage");
        var image = $("img", choiceImage);

        if (zoom != undefined) {
            $(this).prepend(zoomedImageHtml);
            var zoomedImage = $(this).find(".zoomedImage");
            zoomedImage.attr("src", image.attr("src"));
            if (zoomedImage.offset().left < 0) {
                zoomedImage.css("margin-left", marginLeft - zoomedImage.offset().left + 5);
            }
        }
        else {
            choiceImage.addClass("highlightedImageChoice");
        }
    });

    panel.on("mouseleave", ".imageChoice .choice", function () {
        var choiceImage = $(this).find(".choiceImage");
        var image = $("img", choiceImage);

        if (zoom != undefined) {
            $(this).find(".zoomedImage").remove();
        }
        else {
            choiceImage.removeClass("highlightedImageChoice");
        }
    });
}

questionnaireEditor.setImageSelectorClickEvent = function (panel) {
    if (!panel.hasClass("eventsDefined")) {
        panel.addClass("eventsDefined")

        questionnaireEditor.container.on("click", ".imageChoice .choice:not(.disabled)", function () {
            var checkBox = $(this).find(":checkbox");
            var choiceList = $(this).closest(".choiceList");
            var maxAnswers = choiceList.attr("data-maxanswers");

            $(".choice.disabled", choiceList).removeClass("disabled");

            if (checkBox.is(":checked")) {
                checkBox.prop("checked", false);
                $(".choiceImage", $(this)).removeClass("selectedImageChoice");
            }
            else {
                checkBox.prop("checked", true);
                $(".choiceImage", $(this)).addClass("selectedImageChoice");
            }

            var selectedCheckBoxes = $('.choiceImage.selectedImageChoice :checkbox[name=' + checkBox.attr('name') + ']', choiceList);
            var choicesToDisable;

            if (selectedCheckBoxes.length > 0) {
                var isExclusive = checkBox.is("[data-exclusive=true]");

                if (isExclusive || maxAnswers == 1) {
                    choicesToDisable = $('.choiceImage :checkbox[name=' + checkBox.attr('name') + '][value!=' + checkBox.val() + ']', choiceList);
                }
                else if (maxAnswers != null && maxAnswers > 1 && selectedCheckBoxes.length >= maxAnswers) {
                    choicesToDisable = $('.choiceImage:not(.selectedImageChoice) :checkbox[name=' + checkBox.attr('name') + ']', choiceList);
                }
                else {
                    choicesToDisable = $('.choiceImage :checkbox[data-exclusive=true][name=' + checkBox.attr('name') + '][value!=' + checkBox.val() + ']', choiceList)
                }
            }

            if (choicesToDisable) {
                choicesToDisable.each(function () {
                    $(this).prop("checked", false);
                    $(this).closest(".choiceImage").removeClass("selectedImageChoice");

                    if (maxAnswers > 1) {
                        $(this).closest(".choice").toggleClass("disabled", true);
                    }

                    questionnaireEditor.toggleOpenEnd(checkBox);
                });
            }
        });
    }
}

// ----------------- GRIDS -----------------------------------

questionnaireEditor.setChoiceGrid = function (panel) {
    $('table.choiceGrid', panel).each(function () {
        var firstCells = $("tr td:first-child, tr th:first-child", $(this));
        var hasContent = false;

        firstCells.each(function () {
            if ($(this).html().trim().length > 0) {
                hasContent = true;
                return false;
            }
        });

        if (!hasContent) {
            firstCells.remove();
            $(this).find("colgroup.leftLabel").remove();
        }
    });
}

questionnaireEditor.setGridRowHoverEvent = function (panel) {
    function addBackgroundColorStyle(elements, cssClass) {
        $(elements).each(function () {
            if (!$(this).hasClass(cssClass)) {
                if (!$(this).attr('data-background-color') && $(this).css('background-color')) {
                    $(this).attr('data-background-color', $(this).css('background-color'));
                }

                $(this).css('background-color', '');
                $(this).attr('data-bg-classes', Number($(this).attr('data-bg-classes') || 0) + 1);
                $(this).addClass(cssClass);
            }

        });
    }

    function removeBackgroundColorStyle(elements, cssClass) {
        $(elements).each(function () {
            if ($(this).hasClass(cssClass)) {
                var numBgClasses = Number($(this).attr('data-bg-classes') || 0) - 1;
                $(this).attr('data-bg-classes', numBgClasses);
                $(this).removeClass(cssClass);
                if (numBgClasses === 0 && $(this).attr('data-background-color')) {
                    $(this).css('background-color', $(this).attr('data-background-color'));
                }
            }
        });
    }

    function GetAxisElements(cell) {
        var row = cell.closest("tr");
        var elements = $("td.gridItem", row).filter(function (index) {
            var rowspan = $(this).attr("rowspan");
            return rowspan == undefined || rowspan == 1;
        });
        var hasColumn = cell.attr("data-column-position");
        var dataColumnCount = $("td[data-column-position]", row).length;

        if (hasColumn && dataColumnCount > 1) {
            var table = cell.closest("table");
            var columnPosition = cell.attr("data-column-position");
            var choicePosition = cell.attr("data-choice-position");

            if (columnPosition != undefined) {
                var columns;

                if (choicePosition != undefined) {
                    columns = $(".gridItem[data-column-position=" + columnPosition + "][data-choice-position=" + choicePosition + "]", table);
                }
                else {
                    columns = $(".gridItem[data-column-position=" + columnPosition + "]", table);
                }

                elements = elements.add(columns);
            }
        }

        return elements;
    }

    $("table.grid.enableAxisHighlighting", panel)
        .on("mousemove", function (args) {
            var target = $(args.target).closest("td.gridItem");
            var highlightedElements = $(".gridHighlightedAxis", this);
            var elementsToHighlight = GetAxisElements(target);
            removeBackgroundColorStyle(highlightedElements.not(elementsToHighlight), "gridHighlightedAxis");
            addBackgroundColorStyle(elementsToHighlight, "gridHighlightedAxis");
        })
        .on("mouseleave", function (args) {
            removeBackgroundColorStyle($(".gridHighlightedAxis", this), "gridHighlightedAxis");
        });

    $("table.grid.enableAxisSelection tbody .gridRow:not(.gridErrorRow) td.gridItem, table.grid.enableAxisSelection tbody .gridAlternateRow:not(.gridErrorRow) td.gridItem", panel)
        .on("click", function () {
            removeBackgroundColorStyle($("table.grid").find(".gridSelectedAxis"), "gridSelectedAxis");
            addBackgroundColorStyle(GetAxisElements($(this)), "gridSelectedAxis");
        });
}

questionnaireEditor.setGridColumnWidths = function (panel) {
    $('table.grid', panel).each(function () {
        var table = $(this);

        $("tbody tr table.control, tfoot tr table.control", table).each(function () {
            var leftCell = $(this).find("td.leftControls");
            var rightCell = $(this).find("td.rightControls");

            if ($("span", leftCell).width() > 0) {
                leftCell.width($("span", leftCell).outerWidth(true));
            }

            if ($("span", rightCell).width() > 0) {
                rightCell.width($("span", rightCell).outerWidth(true));
            }
        });

        $(".gridRowHeader", table).each(function () {
            var colWidth = $(this).width();

            var span = $(this).find("span");
            var openEnd = $(this).find(".openEndRight");

            if (openEnd.length > 0) {
                span.width(colWidth - openEnd.width());
            }
            else {
                span.css("width", "100%");
            }
        });
    });
}

    // -------------------------------------------------------- //
    // ---------------------  Star Rating --------------------- //
    // -------------------------------------------------------- //

    (function ($) {

        $.widget("voxco.starRating", {

            options: {
                numStars: undefined,
                numParts: undefined,
                disabled: false
            },

            _validateNumStars: function (value) {
                var parsedValue = parseInt(value, 10);
                return (!parsedValue || isNaN(parsedValue)) ? 5 : parsedValue;
            },

            _validateStarParts: function (value) {
                var parsedValue = parseInt(value, 10);
                return (!parsedValue || isNaN(parsedValue)) ? 1 : parsedValue;
            },

            _create: function () {
                var starRating = this;

                starRating.options.numStars = this._validateNumStars(starRating.options.numStars || $(this.element).attr('data-num-stars'));
                starRating.options.numParts = this._validateStarParts(starRating.options.numParts || $(this.element).attr('data-num-star-parts'));

                // Create elements
                var stars = _.flatten(_.map(_.range(0, starRating.options.numStars), function (starNumber) {
                    return _.map(_.range(0, starRating.options.numParts), function (starPart) {
                        return $('<div>').addClass('star off').attr('value', (starNumber + (starPart + 1.0) / starRating.options.numParts).toFixed(3)).append($('<a>')).get(0);
                    });
                }));

                var clearRating = $('<div>').addClass('clearRating off');

                // Replace existing elements in DOM
                $('.star,.clearRating', this.element).remove();
                $(this.element).append(clearRating)
                    .append(stars)
                    .addClass('ui-helper-clearfix');

                this.refreshLayout();
                this.refresh();
                this._bindEvents();
            },

            _addClassToStars: function (cls, value) {
                var currentValue = parseFloat(value);
                if (isNaN(currentValue)) { currentValue = 0; }

                $.each($('.star', this.element), function () {
                    if (parseFloat($(this).attr('value')) <= currentValue) {
                        $(this).removeClass('off').addClass(cls);
                    } else {
                        $(this).addClass('off');
                    }
                });
            },

            _clearHandler: function (args) { args.data.starRating.clearRating(); },
            _simpleMouseEnterHandler: function () { $(this).removeClass('off').addClass('hover'); },
            _simpleMouseLeaveHandler: function () { $(this).addClass('off').removeClass('hover'); },
            _starMouseEnterHandler: function (args) {
                $('.star', args.data.starRating.element).removeClass('off on hover');
                args.data.starRating._addClassToStars('hover', $(this).attr('value'));
            },
            _starMouseLeaveHandler: function (args) { args.data.starRating.refresh(); },
            _starClickHandler: function (args) { args.data.starRating.setRating(parseFloat($(this).attr('value'))); },

            _bindEvents: function () {

                $('.clearRating', this.element).off('click', this._clearHandler)
                    .off('mouseenter', this._simpleMouseEnterHandler)
                    .off('mouseleave', this._simpleMouseLeaveHandler);
                $('.star', this.element).off('click', this._starClickHandler)
                    .off('mouseenter', this._starMouseEnterHandler)
                    .off('mouseleave', this._starMouseLeaveHandler);

                if (!this.options.disabled) {
                    $('.clearRating', this.element).on('click', { starRating: this }, this._clearHandler)
                        .on('mouseenter', { starRating: this }, this._simpleMouseEnterHandler)
                        .on('mouseleave', { starRating: this }, this._simpleMouseLeaveHandler);
                    $('.star', this.element).on('click', { starRating: this }, this._starClickHandler)
                        .on('mouseenter', { starRating: this }, this._starMouseEnterHandler)
                        .on('mouseleave', { starRating: this }, this._starMouseLeaveHandler);
                }
            },

            _setOption: function (key, value) {
                var recreate = false;

                if (key === 'numStars') { arguments[1] = this._validateNumStars(value); }
                if (key === 'numParts') { arguments[1] = this._validateStarParts(value); }

                $.Widget.prototype._setOption.apply(this, arguments);

                if (key === 'numStars' || key === 'numParts') {
                    this._create();
                }

                if (key === 'disabled') {
                    this._bindEvents();
                    this.refresh();
                }
            },

            refresh: function () {
                $('.star', this.element).removeClass('on hover').addClass('off');

                if (!this.options.disabled) {
                    this._addClassToStars('on', $('input', this.element).val());
                }
            },

            refreshLayout: function () {
                var starRating = this;
                var stars = $(".star", starRating.element);
                var clearRating = $(".clearRating", starRating.element);
                var img, url;

                // Fix size of star elements
                function applyStarSize(width, height) {
                    var splittedWidth = width / starRating.options.numParts;
                    stars.width(splittedWidth);
                    stars.height(height);
                    $.each(stars, function () {
                        var offsetPart = parseFloat($(this).attr('value')) - (1 / starRating.options.numParts).toFixed(3);
                        offsetPart = Math.floor(offsetPart) - offsetPart;
                        $('a', this).width(width).height(height).css('margin-left', parseInt(offsetPart * width, 10).toString() + 'px');
                    });
                }

                stars.attr('style', '');
                $('a', stars).attr('style', '');
                var starWidth = stars.width() || $('img.defaultStarImage', starRating.element).width();
                var starHeight = stars.height() || $('img.defaultStarImage', starRating.element).height();
                if (starWidth && starHeight) {
                    applyStarSize(starWidth, starHeight);
                } else {
                    img = $('img.defaultStarImage', starRating.element);
                    if (img.length === 0) {
                        url = $('a', stars).css('background-image').replace("url(", "").replace(")", "").replace(/['"]/gi, '');
                        img = $('<img />');
                        img.hide()
                            .addClass('defaultStarImage')
                            .attr('src', url)
                            .imagesLoaded(function () { applyStarSize($(img).width(), $(img).height()); })
                            .appendTo(this.element);
                    }
                }

                // Fix size of "Clear Rating" element
                clearRating.attr('style', '');
                var clearWidth = clearRating.width() || $('img.defaultClearImage').width();
                var clearHeight = clearRating.height() || $('img.defaultClearImage').height();
                if (clearWidth && clearHeight) {
                    clearRating.width(clearWidth).height(clearHeight);
                } else {
                    img = $('img.defaultClearImage', starRating.element);
                    if (img.length === 0) {
                        url = clearRating.css('background-image').replace("url(", "").replace(")", "").replace(/['"]/gi, '');
                        img = $('<img />');
                        img.hide()
                            .addClass('defaultClearImage')
                            .attr('src', url)
                            .imagesLoaded(function () { clearRating.width($(img).width()).height($(img).height()); })
                            .appendTo(this.element);
                    }
                }
            },

            clearRating: function () {
                $('input', this.element).val('');
                this.refresh();
            },

            getRating: function () {
                var value = parseFloat($('input', this.element).val());
                return isNaN(value) ? null : value;
            },

            setRating: function (value) {
                $('input', this.element).val(value);
                this.refresh();
            },

            destroy: function () {
                $.Widget.prototype.destroy.call(this);
            }

        });
    }(jQuery));


questionnaireEditor.setStarRating = function (panel) {
    $('.starRating', panel).starRating();
}

// --------------- DATE TIME ---------------------------------


// ----------------- OPENEND -----------------------------------

questionnaireEditor.initializeOpenEndEditor = function (panel) {

}

// ----------------- CARDSORT -----------------------------------

questionnaireEditor.initializeCardEditor = function (panel) {
    $(".v-cardListEditor .v-itemsContainer .v-questionEditableItem", panel).each(function () {
        var hideLogic = $(this).attr("data-hidelogic");

        if (hideLogic != null && hideLogic != "") {
            $(this).data("hideIf", JSON.parse(hideLogic));
        }

        a4.setColorPickers($(".v-colorPicker", $(this)));
    });
}

questionnaireEditor.initializeChoiceListAnswerTypeEditor = function (panel) {
    var container = $(panel).find(".choiceListAnswerTypeEditor");

    if (container) {
        var questionType = container.attr("choice-list-answer-type");
        var selectedValue = $("[data-name='" + questionType + "ChoiceListAnswerType']", container).val();
        questionnaireEditor.updateCardListSettingOptions(panel, selectedValue);
    }
}

questionnaireEditor.setCardSort = function (panel) {
    questionnaireEditor.initializeCards(panel);
    questionnaireEditor.organizeCards(panel, true);
}

questionnaireEditor.selectCard = function (panel, bucket, item) {
    item.appendTo(bucket);
    questionnaireEditor.organizeCards(panel, false);
    item.find(".cardValue").val(bucket.attr("data-value"));
}

questionnaireEditor.unselectCard = function (panel, item) {
    var cardGroup = $(".cardList").find(".cardGroup[data-group='" + item.attr("data-group") + "']");

    if (cardGroup != null) {
        item.appendTo(cardGroup);
        item.find(".cardValue").val("");
        questionnaireEditor.organizeCards(panel, false);
    }
}

questionnaireEditor.initializeCards = function (panel) {
    $(".cardSortContent", panel).each(function () {
        $(this).disableSelection();

        var scope = $(this);
        var scopeId = scope.attr("id");
        var textHeight = 0;

        $(".cardList", scope).droppable({
            accept: ".card",
            scope: scopeId
        });

        $(".cardList", scope).on("drop", function (event, ui) {
            questionnaireEditor.unselectCard(panel, ui.draggable);
        });

        $(".bucket", scope).each(function () {
            $(this).droppable({
                accept: ".card",
                scope: scopeId
            });

            $(this).on("drop", function (event, ui) {
                questionnaireEditor.selectCard(panel, $(this), ui.draggable);
            });

            var bucketTextHeight = $(this).find(".headerText").height();

            if (bucketTextHeight > textHeight) {
                textHeight = bucketTextHeight;
            }
        });

        $(".card", scope).each(function () {
            $(this).draggable({
                revert: "invalid",
                helper: "original",
                cursor: "move",
                scope: scopeId,
                stack: ".card",
                containment: $(this).closest(".cardSortContent")
            });

            if ($(this).attr("data-group") == null) {
                $(this).attr("data-group", scopeId + "_default");
            }

            var textDiv = $(this).find(".textDiv");

            if (textDiv != null) {
                var top = ($(this).height() / 2) - (textDiv.height() / 2);

                if (top > 0) {
                    textDiv.css("top", top + "px");
                }
            }
        });

        scope.find(".cardGroup").each(function () {
            var cardGroup = $(this);
            var cardGroupName = cardGroup.attr("data-group");

            scope.find(".card[data-group='" + cardGroupName + "']").each(function () {
                var cardValue = $(this).find('.cardValue').val();

                if (cardValue != null && cardValue != "") {
                    var bucket = scope.find(".bucket[data-value='" + cardValue + "']");

                    if (bucket != null) {
                        $(this).appendTo(bucket);
                    }
                }
                else {
                    $(this).appendTo(cardGroup);
                }
            });

            var groupTextHeight = $(this).find(".headerText").height();

            if (groupTextHeight > textHeight) {
                textHeight = groupTextHeight;
            }
        });

        $(".bucket .headerText, .cardGroup .headerText", scope).height(textHeight);
    });
}

questionnaireEditor.organizeCards = function (panel, initialize) {
    $(".cardGroup, .bucket", panel).each(function () {
        var cardSortContent = $(".cardSortContent", panel);
        var stack = cardSortContent.attr("data-stackcards") === undefined || cardSortContent.attr("data-stackcards") == "true";
        var stackPadding = stack ? 2 : 0;
        var cardsCount = $(this).children(".card").length;
        var firstCard = $(".card", panel).first();
        var textHeight = $(this).find(".headerText").height();
        var cardsWidth = firstCard.outerWidth() + (stackPadding * cardsCount);
        var cardsHeight = firstCard.outerHeight() + (stackPadding * cardsCount);
        var position = $(this).offset();
        var hasHeight = $(this).attr("data-hasheight");

        if (initialize || $(this).is(".bucket")) {
            if (!$(this).attr("data-haswidth")) {
                $(this).width(cardsWidth);
            }

            if (!hasHeight) {
                $(this).height(cardsHeight + textHeight + 8);
            }
        }

        if ($(this).is(".bucket")) {
            position.left += ($(this).outerWidth() / 2) - (cardsWidth / 2);
            position.top += ($(this).outerHeight() / 2) - (cardsHeight / 2);

            if (!hasHeight) {
                position.top += textHeight;
            }
        }

        $(this).children(".card").each(function () {
            $(this).offset(position);
            position.left += stackPadding;
            position.top += stackPadding;
        });
    });
}

// ----------------- CAROUSEL -----------------------------------
var carouselQuestionMapping = [];
var carouselQuestionAndStatementMapping = [];

questionnaireEditor.setCarouselQuestionEvent = function (context) {
    $(document).on("click", ".fa-angle-right", function (e) {
        questionnaireEditor.MoveCarouselStatement($(this), 'next');
    });

    $(document).on("click", ".fa-angle-left", function (e) {
        questionnaireEditor.MoveCarouselStatement($(this), 'prev');
    });
}

questionnaireEditor.updateCarouselAllStatementDimensions = function (container) {
    $(".statement .textDiv", container).each(function () {
        questionnaireEditor.updateStatementTextDivDimensions($(this));
    });
}

questionnaireEditor.updateStatementTextDivDimensions = function (statementTextElement) {
    let divHeight = statementTextElement.outerHeight()
    let lineHeight = parseInt(statementTextElement.css("line-height").replace("px", ""));
    let lineCount = Math.floor(divHeight / lineHeight);

    //Max 7 lines displayed in preview for carousel (Decrement px with increase in number of lines)
    let newMargin;

    if (lineCount == 1) {
        newMargin = 40;
    }
    else if (lineCount < 7) {
        newMargin = 40 - lineCount * 5;
    }
    else {
        newMargin = 0;
    }

    statementTextElement.css({ "margin-top":  + newMargin +"px" });
}

questionnaireEditor.MoveCarouselStatement = function (event, action) {
    var $questionContext = $(event).closest('.v-questionPreview');
    var questionName = $questionContext.find('.carrouselContent').attr('id');
    var currentVisibleStatementId = $questionContext.find(".statement:visible").first().attr('id');
    var statementCount = $questionContext.find('.statement').length;

    if (statementCount > 1) {
        var currentStatementSelectedChoices = $questionContext.find('.statement').closest('.carrouselContent').find('.choice').map(function (cur, index) {
            var inputField = $(this).find('input');
            if (inputField.is(':checked')) {
                return inputField.attr('id')
            }
        }
        ).toArray();

        questionnaireEditor.CreateAndUpdateCarouselQuestionVisibleStatementMapping($questionContext, action, questionName, statementCount);
        questionnaireEditor.CreateAndUpdateCarouselQuestionAndStatementMapping(questionName, currentVisibleStatementId, currentStatementSelectedChoices);
        questionnaireEditor.ShowHideCarouselStatements($questionContext, questionName, questionnaireEditor.GetShowStatementIdForCurrentCarousel(questionName));
    }
}

questionnaireEditor.CreateAndUpdateCarouselQuestionAndStatementMapping = function (questionName, currentVisibleStatementId, currentStatementSelectedChoices) {
    var currentstatement = carouselQuestionAndStatementMapping.find(v => v.StatementId === currentVisibleStatementId && v.QuestionName === questionName);

    if (currentstatement) {
        currentstatement.SelectedValues = currentStatementSelectedChoices.length > 0 ? currentStatementSelectedChoices : [];
    }
    else {
        if (currentVisibleStatementId) {
            carouselQuestionAndStatementMapping.push(
                {
                    "QuestionName": questionName, "StatementId": currentVisibleStatementId,
                    "SelectedValues": currentStatementSelectedChoices.length > 0 ? currentStatementSelectedChoices : []
                })
        }
    }
}

questionnaireEditor.CreateAndUpdateCarouselQuestionVisibleStatementMapping = function (questionContext, direction, questionName, totalStatements) {
    var statementNewIndex = 0;
    var currentQuestion = carouselQuestionMapping.find(v => v.QuestionName === questionName);
    var statementOrderOption = questionContext.find('.statement').map(function (ind, value) {
        return { "OrderIndex": ind, "StatementId": $(this).attr('id') }
    }
    ).toArray();

    if (currentQuestion) {
        if (direction == 'next') {
            if (currentQuestion.CurrentStatementIndex < totalStatements - 1) {
                statementNewIndex = currentQuestion.CurrentStatementIndex + 1;
            }
            else {
                statementNewIndex = 0;
            }
        }
        else if (direction == 'prev') {
            if (currentQuestion.CurrentStatementIndex > 0) {
                statementNewIndex = currentQuestion.CurrentStatementIndex - 1;
            }
            else {
                statementNewIndex = totalStatements - 1;
            }
        }

        currentQuestion.CurrentStatementIndex = statementNewIndex;
        currentQuestion.StatementOrderOption = statementOrderOption;
    }
    else {
        if (direction == 'prev') {
            statementNewIndex = totalStatements - 1;
        }
        else {
            statementNewIndex = 1;
        }
        carouselQuestionMapping.push({ "QuestionName": questionName, "CurrentStatementIndex": statementNewIndex, "StatementOrderOption": statementOrderOption });
    }
}

questionnaireEditor.GetShowStatementIdForCurrentCarousel = function (questionName) {
    var showStatementIndex = 0;
    var currentQuestionMapper = carouselQuestionMapping.find(v => v.QuestionName === questionName);

    if (currentQuestionMapper) {
        showStatementIndex = currentQuestionMapper.CurrentStatementIndex;
    }

    var statementIndexObject = currentQuestionMapper.StatementOrderOption.find(a => a.OrderIndex === showStatementIndex);

    if (statementIndexObject)
        return statementIndexObject.StatementId
    else
        return;
}

questionnaireEditor.ShowHideCarouselStatements = function (currentQuestionContext, questionName, statementIdToShow) {
    if (statementIdToShow) {
        currentQuestionContext.find('.statement').hide();
        currentQuestionContext.find('.choice input').prop('checked', false);

        var statementToShow = currentQuestionContext.find('.statement#' + statementIdToShow + '')
        statementToShow.show();

        if (statementToShow.find('.textDiv').length > 0) {
            questionnaireEditor.updateStatementTextDivDimensions(statementToShow.find('.textDiv'));
        }

        var statementToShow = carouselQuestionAndStatementMapping.find(v => v.StatementId === statementIdToShow && v.QuestionName === questionName);
        var selectedChoices;

        if (statementToShow) {
            selectedChoices = statementToShow.SelectedValues;
        }

        if (selectedChoices && selectedChoices.length > 0) {
            selectedChoices.forEach(function (choice) {
                currentQuestionContext.find('.choice input#' + choice + '').prop('checked', true);
            })
        }
    }
}

questionnaireEditor.ResetStatementSelectionForCarousel = function (panel) {
    var questionName = $(".h-questionTitle", panel).text();

    if (carouselQuestionMapping.find(v => v.QuestionName === questionName)) {
        carouselQuestionMapping = carouselQuestionMapping.filter(item => item && item.QuestionName !== questionName);
        carouselQuestionAndStatementMapping = carouselQuestionAndStatementMapping.filter(item => item && item.QuestionName !== questionName);
    }
}

// ----------------- AUTOCOMPLETE -------------------------------

questionnaireEditor.setAutoCompleteInvalidAsOpenEndEvent = function (context) {
    $(context).on("click", ".v-invalidAsOpenEnd", function () {
        var parent = $(this).closest(".v-advanceSettings");
        $(".v-openEndAnswerCodePanel", parent).toggle();
    });
}

questionnaireEditor.setAutoCompleteShowDropDownEvent = function (context) {
    $(context).on("click", ".v-showDropDown", function () {
        var parent = $(this).closest(".v-advanceSettings");
        $(".v-minSearchLengthPanel", parent).toggle();
        $("#searchOption").val("Contains");
    });
}

questionnaireEditor.setAutoComplete = function (panel) {
    $(".autoComplete > input[type=text]", panel).each(function () {
        var autoComplete = $(this);
        var context = autoComplete.closest(".v-questionPreview");
        var choices = $(".choiceList select option", context).map(function () { return { value: $(this).val(), label: $(this).text().trim() }; }).get();
        var minSearchLength = autoComplete.attr("data-minsearchlength");
        var maxResults = autoComplete.attr("data-maxresults");
        var maxResultsMessage = autoComplete.attr("data-maxresultsmessage");
        var invalidAsOpenEnd = autoComplete.attr("data-invalidasopenend") == "true";
        var autoCompleteValue = $(".autoCompleteValue", context);

        autoComplete.attr("aria-autocomplete", "list");

        autoComplete.autocomplete({
            source: choices,
            minLength: minSearchLength,
            delay: 100,
            focus: function (event, ui) {
                if (ui.item && ui.item.label) {
                    $(this).val(ui.item.label);
                }
                return false;
            },
            change: function (event, ui) {
                questionnaireEditor.selectAutoCompleteItem(ui, autoComplete, autoCompleteValue, invalidAsOpenEnd);
            },
            select: function (event, ui) {
                questionnaireEditor.selectAutoCompleteItem(ui, autoComplete, autoCompleteValue, invalidAsOpenEnd);
                return false;
            }
        });

        autoComplete.data("ui-autocomplete")._renderItem = function (ul, item) {
            return $("<li>").attr("role", "option").data("ui-autocomplete-item", item).append("<a>" + item.label + "</a>").appendTo(ul);
        };

        autoComplete.data("ui-autocomplete")._renderMenu = function (ul, items) {
            ul.attr("role", "listbox");
            var renderItemsCount = items.length;

            if (maxResults > 0) {
                renderItemsCount = Math.min(items.length, maxResults);
            }

            for (var index = 0; index < renderItemsCount; index++) {
                this._renderItem(ul, items[index]);
            }

            if (renderItemsCount != items.length) {
                $("<li>", { "class": "ui-menu-item autocomplete-message" }).append(maxResultsMessage.replace(/{max}/g, renderItemsCount)).appendTo(ul);
            }
        };
    });

    $(panel).on("click", ".autoComplete > .autoCompleteButton", function () {
        var autoComplete = $(this).closest(".autoComplete").find("input[type=text]");
        autoComplete.autocomplete("search", "");
        autoComplete.trigger("focus");
    });
}

questionnaireEditor.selectAutoCompleteItem = function (ui, autoComplete, autoCompleteValue, invalidAsOpenEnd) {
    var item;

    if (ui && ui.item) {
        item = ui.item;
    }
    else {
        var data = autoComplete.autocomplete("option", "source");
        var regexp = new RegExp("^" + $.ui.autocomplete.escapeRegex(autoComplete.val()) + "$", "i");
        var item = _.find(data, function (i) { return i.label.match(regexp); });
    }

    if (item) {
        autoComplete.val(item.label);
        autoCompleteValue.val(item.value);
    }
    else if (invalidAsOpenEnd) {
        autoCompleteValue.val(autoComplete.val());
    }
    else {
        autoComplete.val("");
        autoCompleteValue.val("");
    }
}

// ----------------- LOOKUP TABLE -----------------------------------   lookupTables

questionnaireEditor.initializeLookTableEditor = function (panel) {
    if (!questionnaireEditor.lookupTables)
        questionnaireEditor.loadLookupTables(panel);
    else
        questionnaireEditor.setLookupTableSelector(panel);

    questionnaireEditor.setLookupTableCreate(panel)

    $('.v-qeRichEditText:visible', panel).a4richTextEditor({ library: true, piping: true, inline: true });
}

questionnaireEditor.setLookupTableSelector = function (panel, newName) {
    $(".v-selectLookupTable", panel).each(function () {
        $(this).a4autocomplete({
            data: questionnaireEditor.lookupTables,
            valueProperty: "id",
            labelProperty: "name",
            maxItems: 100,
            select: function (event, ui) {
                $("#LookupTableId", panel).val(ui.item.value);
                var advanceSectionOpen = ($(".v-advanceSettings", panel).length > 0);
                var callback = (advanceSectionOpen) ? function () { questionnaireEditor.setLookupTableFilter(panel); } : null;
                questionnaireEditor.loadLookupTable(panel, ui.item.value, callback);

                if ($(".v-advanceSettings", panel).length > 0) {
                    questionnaireEditor.setLookupTableColumnSelector(panel);
                }
            }
        });
    });

    if (newName) {
        var item = questionnaireEditor.lookupTables.find(x => x.name == newName);
        $(".v-selectLookupTable").a4autocomplete("setValue", item);
    }
}

var addedLookupTable = "";
questionnaireEditor.setLookupTableCreate = function (panel) {
    addedLookupTable = "";
    $(".h-createLookupTable", panel).on("click", function () {
        modalDialog.showWindow(a4.getAction("ImportLookupTable", "Surveys", "Settings"), 450, 650, { afterClose: function () { questionnaireEditor.loadLookupTables(panel); } });
    });
}

questionnaireEditor.loadLookupTables = function (panel) {
    a4.callServerMethod(questionnaireEditor.getUrl("GetLookupTables"), {},
        function (result) {
            questionnaireEditor.lookupTables = [];

            $.each(result, function (index, item) {
                questionnaireEditor.lookupTables.push({ value: item.Id, name: item.Name });
            });

            questionnaireEditor.setLookupTableSelector(panel, addedLookupTable);
        });
}

questionnaireEditor.initializeLookTableAdvanceEditor = function (panel) {
    questionnaireEditor.setLookupTableColumnSelector(panel);
    questionnaireEditor.setLookupTableFilter(panel);

    $(panel).on("change", ".v-columName", function () {
        questionnaireEditor.setLookupTableFilter(panel);
    });
}

questionnaireEditor.setLookupTableColumnSelector = function (panel) {
    var tableName = $(".v-selectLookupTable", panel).val()

    a4.callServerMethod(questionnaireEditor.getUrl("GetLookupTableColumns"), { tableName: tableName },
        function (result) {
            var columns = _.map(result, function (r) { return { "name": r }; });

            var sortItem = $(".v-selectLookupSortColumn", panel);

            sortItem.a4autocomplete({
                data: columns,
                valueProperty: "name",
                labelProperty: "name"
            });

            if (!_.some(columns, function (c) { return c.name == sortItem.val(); }))
                sortItem.val("");
        });
}

questionnaireEditor.setLookupTableFilter = function (panel) {
    var questionId = questionnaireEditor.blockController.getBlockItemIdFromElement(panel);
    var loopkupVariables = $(".v-lookupColumnsEditor .v-questionEditableItem:visible", panel).map(function () { return { "name": $(this).find(".v-columName").val(), "value": $(this).attr("id").replace("ColumnRow", ""), "questionId": questionId }; }).get();
    a4logicEditor.variableSource = loopkupVariables;
    a4logicEditor.setVariableAutoComplete($(".v-lookupFilter", panel));

    $(".v-questionEditableItem:visible .v-logicVariable", panel).each(function () {
        var value = $(this).val();

        if (!_.some(loopkupVariables, function (v) { return v.name == value; })) {
            $(this).val("")
        }
    });

    $(".v-advanceLink", panel).remove();
}


questionnaireEditor.loadLookupTable = function (panel, tableId, callback) {
    var questionId = questionnaireEditor.blockController.getBlockItemIdFromElement(panel);
    a4.callServerMethod(questionnaireEditor.getUrl("GetLookupTableEditor"), { questionId: questionId, tableId: tableId },
        function (result) {
            var contentBody = $(".v-lookupColumnsEditor .v-lookupColumnsBody", panel);

            if (contentBody.length == 0) {
                $(".v-lookupColumnsEditor", panel).replaceWith(result);
                contentBody = $(".v-lookupColumnsEditor .v-lookupColumnsBody", panel);
            }
            else {
                $('tr[id="#ColumnName0"]', contentBody).remove();
                $('tr[id!="#ColumnName0"]', contentBody).addClass("deleted").hide();

                var rows = $("<div>").html(result).find(".v-lookupColumnsBody").html();
                contentBody.append(rows);
            }

            $('.v-qeRichEditText:visible', contentBody).a4richTextEditor({ library: true, piping: true, inline: true });

            if (callback)
                callback();
        });
}


questionnaireEditor.setLookupTablePreview = function (panel) {
    $(".h-questionTable", panel).each(function () {
        var tableId = $(this).attr("data-tableId");
        var dataColumns = JSON.parse($(this).attr("data-columns"));
        var filter = $(this).attr("data-filter");
        var sortDirection = $(this).attr("data-sortDirection");
        var sortIndex = Math.max(0, _.indexOf(_.pluck(dataColumns, "Data"), $(this).attr("data-sortColumn"))) + 1;
        var searchColumns = $(this).attr("data-searchColumns");
        var maxAnswerVal = $(this).attr("data-maxAllowed") != "" ? parseInt($(this).attr("data-maxAllowed"), 10) : 100;
        var pageSize = $(this).attr("data-pageSize");

        if (tableId && dataColumns) {
            $(this).find("table").sedatatable({
                displayColumnSelector: false,
                generateTableStructure: false,
                ajaxAction: a4.getAction("GetLookupTablePreview", "Questionnaire", "Survey"),
                ajaxParams: { "tableId": tableId, "filter": filter, "searchColumns": searchColumns },
                defaultSorting: [[sortIndex, sortDirection]],
                displayLength: pageSize,
                columns: dataColumns,
                displaySearchBox: false,
                allowRowSelection: true,
                limitRowSelection: maxAnswerVal
            });
        }
    });
}

questionnaireEditor.initializeTimeAdvanceEditor = function (panel) {
    var actionDropdown = $(".h-timerAction", panel);
    var updateAction = function () {
        var dropdownValue = actionDropdown.val();
        var terminateAction = $(".h-timerTerminateAction", panel).val();
        var isTerminateSurvey = dropdownValue == "4";

        $(".v-timerDisplayMessage", panel).toggle(dropdownValue == "3");
        $(".v-timerTerminationAction", panel).toggle(isTerminateSurvey);
        $(".v-timerTerminateSurveyMessage", panel).toggle(isTerminateSurvey && terminateAction == "1");
        $(".v-timerTerminateSurveyURL", panel).toggle(isTerminateSurvey && terminateAction == "2");
    };

    $(".h-timerAction, .h-timerTerminateAction").on("change", function () {
        updateAction();
    });

    updateAction();
}

questionnaireEditor.adjustNumericRankingTextWidth = function (panel) {
    var textWidth = 0;

    if ($(".numericRanking", panel).hasClass("left")) {
        $(".numericRanking.left li.rankingItem", panel).each(function () {
            var textDiv = $(this).find(".textDiv");

            if (textDiv.width() > textWidth)
                textWidth = textDiv.width();
        });

        if (textWidth > 0)
            $(".numericOptionsList li.rankingItem > .textDiv", panel).width(textWidth);
    }
    else {
        var headerWidth = $(".numericRanking li.header", panel).find(".textDiv").width();
        var inputDivWidth = $(".numericRanking li.rankingItem", panel).find(".inputDiv:first").width();

        if (headerWidth > inputDivWidth)
            $(".numericOptionsList li.rankingItem > .inputDiv", panel).width(headerWidth);
    }
}

// ----------------- Text Highlight Update Version -------------------
var stopwordList = [];
var latestSavedStatus = [];
var isDragging = false;
var dragStartButton = null;
var lastClickedButton = null;
var prevButtonStates = null;
var inputTimeout = null;

questionnaireEditor.setTextHighlighterEvents = function (context) {
    $(context).on("click", ".h-pureTextButton", function () {
        if ($(".v-textHighlighter-input").hasClass("highlighted")) {
            questionnaireEditor.setPureTextView();
            $(".v-textHighlighter-input").toggleClass("highlighted");
        }
    });

    $(context).on("click", ".h-highlightTextButton", function () {
        if (!$(".v-textHighlighter-input").hasClass("highlighted")) {
            questionnaireEditor.cleanPressHistory();
            questionnaireEditor.setHighlightTextView();
            questionnaireEditor.checkStopWords();
            $(".v-textHighlighter-input").toggleClass("highlighted");
        }
    });

    $(context).on("click", ".h-texthighlightCombineButton", function () {
        prevButtonStates = questionnaireEditor.saveButtonStates();
        questionnaireEditor.mergeSelectedButtons();
        questionnaireEditor.reAssignTokenPosition();
        questionnaireEditor.checkStopWords();
        questionnaireEditor.showAppropriateButtons();
    });

    $(context).on("click", ".h-texthighlightUngroupButton", function () {
        prevButtonStates = questionnaireEditor.saveButtonStates();
        questionnaireEditor.revertMergedButtons();
        questionnaireEditor.reAssignTokenPosition();
        $('.token.selected, .ign.selected').removeClass('selected');
        questionnaireEditor.checkStopWords();
        questionnaireEditor.showAppropriateButtons();
    });

    $(context).on("click", ".h-texthighlightAddButton", function () {
        questionnaireEditor.addHighlight();
        questionnaireEditor.showAppropriateButtons();
    });

    $(context).on("click", ".h-texthighlightRemoveButton", function () {
        questionnaireEditor.removeHighlight();
        questionnaireEditor.showAppropriateButtons();
    });
}

questionnaireEditor.initializeTextHighlighterTokensEvents = function (panel) {

    // create the tooltip element when the script loads
    questionnaireEditor.createTooltipElement();
    questionnaireEditor.cleanPressHistory();
    $('.v-questionEditTitle:visible', panel).a4richTextEditor({ library: true, piping: true, inline: true });
    $(".v-textHighlighter-input:visible").a4richTextEditor({ library: true, piping: true, inline: true, pastePlain: false});
    $('.v-textHighlighter-input:visible').removeClass('editable');
    $(".v-textHighlighter-input:visible").froalaEditor("edit.off");

    $('.v-textHighlighter-input', panel).on('mousedown', function (event) {
        if (!$(event.target).is('.token, .ign')) {
            $('.token, .ign').removeClass('selected');
            questionnaireEditor.showAppropriateButtons();
        }
    });

    $('.v-textHighlighter-input', panel)
        .on('click', '.token, .ign', function (event) {
            if (!isDragging) {
                const $button = $(event.target);
                questionnaireEditor.handleMouseDown($button, event);
            }
        })
        .on('mousedown', '.token, .ign', function (event) {
            dragStartButton = $(event.target);

            $('.v-textHighlighter-input', panel).on('mousemove', function () {
                isDragging = true;
                $('.v-textHighlighter-input', panel).off('mousemove');
            });
        })
        .on('mouseenter', '.token, .ign', function (event) {
            if (isDragging) {
                const $target = $(event.target);
                questionnaireEditor.updateSelection(dragStartButton, $target);
            }
        })
        .on('mouseup', function () {
            isDragging = false;
            dragStartButton = null;
            $('.v-textHighlighter-input', panel).off('mousemove');
        });

    var questionId = questionnaireEditor.blockController.getBlockItemIdFromElement(panel);
    a4.callServerMethod(questionnaireEditor.getUrl("GetTextHighlightStopwords"), { questionId: questionId },
        function (result) {
            stopwordList = result;
        });
    a4.callServerMethod(questionnaireEditor.getUrl("GetLatestSavedTextHighlightStatus"), { questionId: questionId },
        function (result) {
            latestSavedStatus = result;
        });
};

questionnaireEditor.createTooltipElement = function () {
    const tooltip = document.createElement('div');
    tooltip.id = 'choice-code-tooltip';
    tooltip.style.display = 'none';
    tooltip.style.position = 'absolute';
    tooltip.style.padding = '3px';
    tooltip.style.backgroundColor = '#D7D7D7';
    tooltip.style.borderRadius = '4px';
    tooltip.style.zIndex = '9999';

    const inputLabel = document.createTextNode('Code');
    tooltip.appendChild(inputLabel);

    const input = document.createElement('input');
    input.type = 'text';
    input.id = 'choice-code-input';
    input.style.width = '40px';
    input.style.marginLeft = '5px';
    tooltip.appendChild(input);

    document.body.appendChild(tooltip);
    $('#choice-code-input').on("input", function (e) {
        clearTimeout(inputTimeout);
        inputTimeout = setTimeout(function () {
            return questionnaireEditor.DisableInvalidInput(e);
        }, 5);
    });
}

questionnaireEditor.showTooltip = function ($button) {
    const tooltip = document.getElementById('choice-code-tooltip');
    const input = document.getElementById('choice-code-input');
    const buttonOffset = $button.offset();
    const buttonHeight = $button.outerHeight();

    // Set the tooltip position above the button
    tooltip.style.left = buttonOffset.left + 'px';
    tooltip.style.top = (buttonOffset.top - tooltip.offsetHeight - 5) + 'px'; // subtract height of tooltip and 5px spacing

    // Set the input value to the button's choiceCode attribute
    input.value = $button.attr('mappedchoiceCode');
    const previousValue = input.value;

    // Update the choiceCode / UserModifed attribute when the input value changes
    input.oninput = function () {
        if (input.value.trim().length > 0) {
            $button.attr('mappedChoiceCode', input.value);
            $button.attr('userModified', true);
        } else {
            $button.attr('mappedChoiceCode', previousValue);
            $button.attr('userModified', false);
        }
    };

    // Show the tooltip
    tooltip.style.display = 'block';
}

questionnaireEditor.DisableInvalidInput = function (e) {
    var inputElem = e.target;
    var inputChar = inputElem.value;
    if (inputChar.match(/[^\w\-\_\.]/g)) {
        inputElem.value = inputChar.replace(/[^\w\-\_\.]/g, '');
        return false;
    } else {
        return true;
    }
}

questionnaireEditor.hideTooltip = function () {
    const tooltip = document.getElementById('choice-code-tooltip');
    if (tooltip) {
        tooltip.style.display = 'none';
    }
}

questionnaireEditor.setAddHighlightCategoryRowEvent = function (context) {
    $(context).on("click", ".v-highlightCategoryListEditor .v-addPanel .h-addItemRow", function () {
        var container = $(this).closest(".v-questionEdit");
        var highlightCategoryEditor = $(this).closest(".v-highlightCategoryListEditor");

        var category = $(".v-newHighlightCategory tbody tr", highlightCategoryEditor).clone(false);
        var questionName = $(".v-questionName", container).val();
        var variableName = questionName.toUpperCase() + "_" + ($(".v-questionEditableItem:visible", highlightCategoryEditor).length + 1);
        $(".v-highlightCategoryName", category).val(variableName);
        $(category).appendTo($("table .v-highlightCategoryListBody", highlightCategoryEditor));

        $('.v-qeRichEditText:visible', category).a4richTextEditor({ library: true, piping: true, inline: true });
        highlightCategoryEditor.trigger('rowAdded', category);

        $(this).scrollIntoView();

        a4ImageSelector.bindElements(category);
        a4.setColorPickers($(".v-highlightCategoryColorColumn:not(.hidden) .v-colorPicker", category));
    });
}

questionnaireEditor.setEditHighlightCategoryLogicRowEvent = function (context) {
    $(context).on("click", ".v-highlightCategoryListTable .h-editRowLogic", function () {
        var categoryRow = $(this).closest(".v-questionEditableItem");
        var categoryQuestion = $(this).closest(".v-highlightCategoryListEditor");

        var hideLogic = categoryRow.data("hideIf");
        questionnaireEditor.editHighlightCategoryHideLogic(categoryQuestion, hideLogic, categoryRow);
    });
}

questionnaireEditor.editHighlightCategoryHideLogic = function (highlightCategoryQuestion, logic, highlightCategoryRow) {
    var highlightCategoryLogicEditor = $('.v-highlightCategoryLogicEditor', highlightCategoryQuestion).clone(true).show();
    var logicEditor = $('.v-logicEditor', highlightCategoryLogicEditor);
    var content = $('<div id="EditHighlightCategoryLogicContainer">').append(logicEditor.outerHTML());

    var logicResources = {
        "Title": questionnaireEditor.resources.CategoryHideIf,
        "Message": content
    };

    modalDialog.showConfirmDialog(logicResources,
        function () {
            a4logicEditor.hasError = false;

            var oldId = (logic && logic.Id) || 0;
            var newLogic = a4logicEditor.getLogic(content, true);
            var hasLogic = (newLogic != null && (newLogic.Conditions.length > 0 || (newLogic.SyntaxType == "Advanced" && newLogic.CustomCondition.trim().length > 0)));

            newLogic.Id = oldId;

            if (!a4logicEditor.hasError) {
                highlightCategoryRow.data("hideIf", newLogic);
            }

            if (hasLogic) {
                $(".h-editRowLogic", highlightCategoryRow).removeClass("skip");
            }
            else {
                $(".h-editRowLogic", highlightCategoryRow).addClass("skip");
            }
        }, 400, 600, null, null, {
        initFunction: function () {
            var logicEditor = $('#EditHighlightCategoryLogicContainer .v-logicEditor');
            a4logicEditor.updateVariables();
            a4logicEditor.editInlineTypeLogic(logicEditor, logic, questionnaireEditor.allowAdvanceLogic);
            a4logicEditor.editInlineConditionLogic(logicEditor, logic, questionnaireEditor.getInEditQuestion());
        }
    });
}

questionnaireEditor.disableHighlightCategoriesInvalidCharactersEvent = function (context) {
    $(context).on("keypress", ".v-highlightCategoryListTable .v-questionEditableItem .v-highlightCategoryName", function (e) { return DisableInvalidCharacters(e); });
    $(context).on("keypress", ".v-highlightCategoryListTable .v-questionEditableItem input", function (e) { return DisableEnter(e); });
}

questionnaireEditor.setTextHightlighterPureTextButton = function (isActive) {
    if (!isActive) {
        $(".h-pureTextButton").attr("disabled", "true");
    }
    else {
        $(".h-pureTextButton").removeAttr("disabled");
    }
}

questionnaireEditor.setTextHightlighterHighlightTextButton = function (isActive) {
    if (!isActive) {
        $(".h-highlightTextButton").attr("disabled", "true");
    }
    else {
        $(".h-highlightTextButton").removeAttr("disabled");
    }
}

questionnaireEditor.updateSelection = function ($startButton, $endButton) {
    const $buttons = $('.token, .ign');
    const startIndex = $buttons.index($startButton);
    const endIndex = $buttons.index($endButton);
    const minIndex = Math.min(startIndex, endIndex);
    const maxIndex = Math.max(startIndex, endIndex);

    $buttons.each(function (index, button) {
        const $button = $(button);
        if (index >= minIndex && index <= maxIndex) {
            $button.addClass('selected');
        } else {
            $button.removeClass('selected');
        }
    });

    questionnaireEditor.showAppropriateButtons();
}

questionnaireEditor.createButtons = function ($element) {
    var choiceCode = 1;
    var savedButtonStateIndex = 0;

    function getParentStyles(element) {
        const styles = [];
        while (element.parentNode) {
            const style = element.parentNode.getAttribute('style');
            if (style) styles.push(style);
            element = element.parentNode;
        }
        return styles.reverse().join('; ');
    }

    function createWordSpan(savedState, style) {
        const wordSpan = $('<span>', {
            class: 'token v-questionEditableItem',
            html: savedState.text,
            style: style,
        });

        wordSpan.attr('isgroup', savedState.isGroup ? 'true' : 'false');
        wordSpan.attr('highlightable', savedState.highlightable);
        wordSpan.attr('choiceCode', choiceCode++);
        wordSpan.attr('userModified', savedState.userModified);
        wordSpan.attr('mappedChoiceCode', savedState.mappedChoiceCode);

        if (savedState.isGroup) {
            wordSpan.attr('data-spaces', savedState.dataspaces);
        }

        return wordSpan;
    }

    function wrapWords(element) {
        const nodeValue = element.nodeValue;
        const fragment = document.createDocumentFragment();
        var currentIndex = 0;

        // Recursively process all child nodes if any exist
        if (element.childNodes && element.childNodes.length > 0) {
            for (let i = 0; i < element.childNodes.length; i++) {
                wrapWords(element.childNodes[i]);
            }
        }

        while (currentIndex < nodeValue.length) {
            var savedState = prevButtonStates[savedButtonStateIndex];
            var nextSavedState = prevButtonStates[savedButtonStateIndex + 1];
            var combinedStateText = savedState ? savedState.text : '';

            // Check if current and next saved states together match a segment of original text
            while (nextSavedState && nodeValue.substr(currentIndex, combinedStateText.length + nextSavedState.text.length) === combinedStateText + nextSavedState.text) {
                combinedStateText += nextSavedState.text;
                savedState = nextSavedState; // For this combined state, we'll use attributes from the last state
                savedButtonStateIndex++;
                nextSavedState = prevButtonStates[savedButtonStateIndex + 1];
            }

            if (savedState && nodeValue.substr(currentIndex, savedState.text.length) === savedState.text) {
                const words = savedState.text;
                if (words.trim()) {
                    const wordSpan = createWordSpan(savedState, getParentStyles(element));
                    fragment.appendChild(wordSpan.get(0));
                } else {
                    const textNode = document.createTextNode(word);
                    fragment.appendChild(textNode);
                }
                currentIndex += savedState.text.length;
                savedButtonStateIndex++;
            } else {
                const match = nodeValue.substr(currentIndex).match(/(\S+|\s+)/);
                if (match) {
                    const word = match[0];
                    if (/\S/.test(word) && word.replace(/\u200B/g, '')) {

                        const wordSpan = $('<span>', {
                            class: 'token v-questionEditableItem',
                            html: word,
                            style: element.parentNode.getAttribute('style'),
                        });

                        wordSpan.attr('isgroup', false);
                        wordSpan.attr('highlightable', true);
                        wordSpan.attr('choiceCode', (choiceCode++));
                        wordSpan.attr('userModified', false);
                        wordSpan.attr('mappedChoiceCode', 0);

                        fragment.appendChild(wordSpan.get(0));

                    } else {
                        const textNode = document.createTextNode(word);
                        fragment.appendChild(textNode);
                    }
                    currentIndex += word.length;
                } else {
                    break;
                }
            }
        }

        return fragment;
    }

    function traverseNodes(node, textNodes) {
        if (node.nodeType === Node.TEXT_NODE) {
            textNodes.push(node);
        } else if (node.nodeType === Node.ELEMENT_NODE) {
            const tag = node.tagName.toLowerCase();
            if (['img', 'a', 'video'].includes(tag)) {
                return;
            }
            const children = node.childNodes;
            for (let i = 0; i < children.length; i++) {
                traverseNodes(children[i], textNodes);
            }
        }
    }

    $element.each(function () {
        const textNodes = [];
        traverseNodes(this, textNodes);
        textNodes.forEach((textNode) => {
            const fragment = wrapWords(textNode);
            textNode.replaceWith(fragment);
        });
    });
}

questionnaireEditor.revertButtons = function ($element) {
    if ($element.is('img') || $element.is('a') || $element.is('video')) {
        return $element.clone();
    }

    function revertElement($span) {
        var originalTag = $span.data('original-tag');
        var style = $span.attr('style');

        if ($span.hasClass('token') || $span.hasClass('ign')) {
            return document.createTextNode($span.text());
        }

        // If originalTag is undefined or empty, return the text
        if (!originalTag) {
            return $span;  // If no originalTag, keep the current element
        }

        // Create a new element with the original tag
        var $newElement = $('<' + originalTag + '>', {});

        if (originalTag === 'span') {
            $newElement.attr('style', style);
        }

        // Process the contents of the span
        $span.contents().each(function () {
            if (this.nodeType === Node.ELEMENT_NODE) {
                // If this is an element node, revert it
                const $revertedChild = revertElement($(this));  // Recursive call
                $newElement.append($revertedChild);
            } else {
                // Otherwise, append the node directly (it is a text node)
                $newElement.append(this);
            }
        });

        return $newElement;
    }

    $element.find('span').each(function () {
        var $span = $(this);
        var $newElement = revertElement($span);  // Call the recursive function
        $span.replaceWith($newElement);
    });
};

questionnaireEditor.isStopWord = function (word) {
    return stopwordList.includes(word.toLowerCase());
};

questionnaireEditor.mergeSelectedButtons = function () {
    const $selectedButtons = $('.token.selected, .ign.selected');
    if ($selectedButtons.length === 0 || $selectedButtons.length === $selectedButtons.filter('.ign').length) {
        return;
    }
    $('.ign.selected').removeClass('ign').addClass('token');

    const groups = questionnaireEditor.groupButtonsByBlockLevel($selectedButtons);
    groups.forEach((group) => {
        const mergedContent = group
            .map((button, index) => {
                const prevButton = group[index - 1];
                let space = '';

                // Check if there is a space between the current button and the previous one
                if (prevButton) {
                    const spaceNode = button.get(0).previousSibling;
                    if (spaceNode && spaceNode.nodeType === Node.TEXT_NODE && spaceNode.textContent.match(/^\s+$/)) {
                        space = spaceNode.textContent;
                    }
                }

                return space + button.text();
            })
            .join('');

        const mergedButton = $('<span>', {
            class: 'merged-button token v-questionEditableItem',
            html: mergedContent,
            'data-spaces': group.slice(1).map(button => {
                const spaceNode = button.get(0).previousSibling;
                return spaceNode && spaceNode.nodeType === Node.TEXT_NODE ? spaceNode.textContent : '';
            }).join('|'),
            isGroup: true,
            highlightable: true
        });

        // Copy the style from first button
        mergedButton.attr('style', group[0].attr('style'));

        // Assign choiceCode to the merged button
        var choiceCode = $(group[0]).attr('choiceCode');
        if (choiceCode) {
            mergedButton.attr('choiceCode', choiceCode);
        }
        mergedButton.attr('mappedChoiceCode', 0);

        // Once the user modified choice is merged, the button is no longer the same, so reset the attribute
        mergedButton.attr('userModified', false);

        // Replace the first button with the merged button
        group[0].replaceWith(mergedButton);

        // Remove the remaining buttons and their associated space nodes
        for (let i = 1; i < group.length; i++) {
            const spaceNode = group[i].get(0).previousSibling;
            if (spaceNode && spaceNode.nodeType === Node.TEXT_NODE && spaceNode.textContent.match(/^\s+$/)) {
                spaceNode.remove();
            }
            group[i].remove();
        }
    });
}

questionnaireEditor.revertMergedButtons = function () {
    $('.merged-button.selected').each(function () {
        const $mergedButton = $(this);
        const mergedText = $mergedButton.html().replace(/&nbsp;/g, ' ');
        const spaces = $mergedButton.data('spaces').split('|');
        const fragment = document.createDocumentFragment();

        const words = mergedText.split(/\s+/);
        words.forEach((word, index) => {
            const isIgn = $mergedButton.hasClass('ign') || questionnaireEditor.isStopWord(word);
            const wordSpan = $('<span>', {
                class: isIgn ? 'ign v-questionEditableItem' : 'token v-questionEditableItem',
                html: word,
                style: $mergedButton.attr('style'),
                isGroup: false,
                highlightable: isIgn ? false : true
            });

            // Assign choiceCode to the ungrouped button
            var choiceCode = $mergedButton.attr('choiceCode');
            if (choiceCode) {
                wordSpan.attr('choiceCode', choiceCode);
            }
            wordSpan.attr('mappedChoiceCode', 0);

            // Reset user modified status if the button got merge / revert merge
            wordSpan.attr('userModified', false);

            fragment.appendChild(wordSpan.get(0));

            // Add the space after the word
            if (index < spaces.length) {
                const textNode = document.createTextNode(spaces[index]);
                fragment.appendChild(textNode);
            }
        });

        $mergedButton.replaceWith(fragment);
    });
};

questionnaireEditor.groupButtonsByBlockLevel = function ($selectedButtons) {
    const groups = [];
    let currentGroup = [];

    $selectedButtons.each(function (index, button) {
        const $button = $(button);
        const $prevButton = $(button).prev('.token.selected');
        const sameBlockLevel = $prevButton.length > 0 && $button.closest('div').get(0) === $prevButton.closest('div').get(0);

        if (sameBlockLevel) {
            currentGroup.push($button);
        } else {
            if (currentGroup.length > 0) {
                groups.push(currentGroup);
            }
            currentGroup = [$button];
        }

        if (index === $selectedButtons.length - 1 && currentGroup.length > 0) {
            groups.push(currentGroup);
        }
    });

    return groups;
}

questionnaireEditor.handleMouseDown = function ($button, event) {
    if (!isDragging) {
        if (event.shiftKey) {
            questionnaireEditor.handleShiftClick($button);
        } else if (event.ctrlKey || event.metaKey) {
            questionnaireEditor.handleCtrlClick($button);
        } else {
            questionnaireEditor.handleNormalClick($button);
        }
        lastClickedButton = $button;
    }
    questionnaireEditor.showAppropriateButtons();
}

questionnaireEditor.handleShiftClick = function ($button) {
    if (lastClickedButton) {
        const $buttons = $('.token, .ign');
        const startIndex = $buttons.index(lastClickedButton);
        const endIndex = $buttons.index($button);

        $buttons.slice(Math.min(startIndex, endIndex), Math.max(startIndex, endIndex) + 1).addClass('selected');
    } else {
        $button.toggleClass('selected');
    }
    questionnaireEditor.showAppropriateButtons();
}

questionnaireEditor.handleCtrlClick = function ($button) {
    $button.toggleClass('selected');
    questionnaireEditor.showAppropriateButtons();
}

questionnaireEditor.handleNormalClick = function ($button) {
    const isAlreadySelected = $button.hasClass('selected');
    $('.token.selected, .ign.selected').not($button).removeClass('selected');
    if (!isAlreadySelected) {
        $button.addClass('selected');
    }
    questionnaireEditor.showAppropriateButtons();
}

questionnaireEditor.setHighlightTextView = function () {
    questionnaireEditor.setTextHightlighterPureTextButton(true);
    questionnaireEditor.setTextHightlighterHighlightTextButton(false);
    $(".v-textHighlighter-input:visible").froalaEditor("edit.off");
    var tempDiv = $("<div>");
    tempDiv.html($(".v-textHighlighter-input .fr-element").html());
    questionnaireEditor.flattenStyles(tempDiv);
    questionnaireEditor.createButtons(tempDiv);
    $(".v-textHighlighter-input .fr-element").html(tempDiv.html());
    questionnaireEditor.reAssignTokenPosition();
}

questionnaireEditor.setPureTextView = function () {
    $(".v-textHighlighter-input .token").removeClass("selected");
    $(".v-textHighlighter-input .ign").removeClass("selected");
    questionnaireEditor.setTextHightlighterPureTextButton(false);
    questionnaireEditor.setTextHightlighterHighlightTextButton(true);
    prevButtonStates = questionnaireEditor.saveButtonStates();
    var tempDiv = $("<div>");
    tempDiv.html($(".v-textHighlighter-input .fr-element").html());
    questionnaireEditor.revertButtons(tempDiv);
    $(".v-textHighlighter-input .fr-element").html(tempDiv.html());
    $(".v-textHighlighter-input:visible").froalaEditor("edit.on");
    questionnaireEditor.showAppropriateButtons();
};

questionnaireEditor.addHighlight = function () {
    $('.ign.selected').each(function () {
        const $this = $(this);
        if (!questionnaireEditor.isStopWord($this.text())) {
            $this.removeClass('ign selected').addClass('token').attr('highlightable', true);
        }
        else {
            $(this).removeClass('selected');
        }
    });
    $('.token.selected').removeClass('selected');
};

questionnaireEditor.removeHighlight = function() {
    $('.token.selected').removeClass('token selected').addClass('ign').attr('highlightable', false);
    $('.ign.selected').removeClass('selected');
}

questionnaireEditor.initializeTextHighlighterCategoriesEvents = function (panel) {
    $(".v-highlightCategoryListEditor .v-itemsContainer .v-questionEditableItem", panel).each(function () {
        var hideLogic = $(this).attr("data-hidelogic");

        if (hideLogic != null && hideLogic != "") {
            $(this).data("hideIf", jQuery.parseJSON(hideLogic));
        }

        a4.setColorPickers($(".v-colorPicker", $(this)));
    });
}

questionnaireEditor.initializeTextHighlighterAdvanceEditor = function (itemPanel) {
    stopwordList = $("#wordsSection .stop-word", itemPanel).map(function () { return $(this).text() }).get();
}

questionnaireEditor.setTextHighlighterStopwordsEvents = function (panel) {
    $(panel).on('keydown', ".v-stopwords", function (ev) {
        var parent = $(this).closest(".v-advanceSettings");
        var value = $(".v-stopwords", parent).val();
        if ((ev.key == 'Enter' || ev.keyCode === 13) && value.trim() !== '') {
            questionnaireEditor.addStopWords(value);
            $(".v-stopwords", parent).val('');
        }
    });
}

questionnaireEditor.getStopWordsList = function () {
    return stopwordList;
};

questionnaireEditor.renderStopWords = function () {
    var wordssection = $("#wordsSection");
    for (var index = 0; index < stopwordList.length; index++) {
        var section = $("<div id='word" + index + "'>").addClass("element-section");
        $(section).addClass("stop-word").append(stopwordList[index])
            .append($("<span class='remove-word' onclick='questionnaireEditor.removeStopWords(" + index + ");return false'>").append($("<i class='fa fa-times'>"))
            );
        $(wordssection).append(section);
    }
};

questionnaireEditor.removeStopWords = function (index) {
    $("#wordsSection").empty();
    var removedWord = stopwordList[index].toLowerCase();
    stopwordList.splice(index, 1);
    questionnaireEditor.renderStopWords();
    var totalTokens = $(".v-textHighlighter-input .ign");
    totalTokens.each(function () {
        if ($(this).text().toLowerCase() == removedWord) {
            $(this).attr("highlightable", "true").removeClass("ign").addClass("token");
        }
    });
}

questionnaireEditor.addStopWords = function (stopWord) {
    if (stopwordList.includes(stopWord)) {
        return; // Do nothing if stopword already in list
    }
    $("#wordsSection").empty();
    stopwordList.push(stopWord.toLowerCase());
    questionnaireEditor.renderStopWords();
    var totalTokens = $(".v-textHighlighter-input .token");
    totalTokens.each(function () {
        if ($(this).text().toLowerCase() == stopWord.toLowerCase()) {
            $(this).attr("highlightable", "false").removeClass("token").addClass("ign");
        }
    });
};

questionnaireEditor.checkStopWords = function() {
    var totalTokens = $(".v-textHighlighter-input .token");
    totalTokens.each(function () {
        if (stopwordList.includes($(this).text().toLowerCase())) {
            $(this).attr("highlightable", "false").removeClass("token").addClass("ign");
        }
    });
}

questionnaireEditor.cleanPressHistory = function () {
    $(".v-textHighlighter-input .token").removeClass("selected");
    $(".v-textHighlighter-input .ign").removeClass("selected");
    questionnaireEditor.setTextHightlighterPureTextButton(true);
    questionnaireEditor.setTextHightlighterHighlightTextButton(false);
    questionnaireEditor.showAppropriateButtons();
};

questionnaireEditor.areSelectedElementsConsecutive = function () {
    const $selectedButtons = $('.token.selected, .ign.selected');
    if ($selectedButtons.length < 2) {
        return false;
    }

    let isConsecutive = true;
    $selectedButtons.each(function (index) {
        if (index === 0) return true;

        const prevElement = $selectedButtons[index - 1];
        if (this.previousElementSibling !== prevElement) {
            isConsecutive = false;
            return false;
        }
    });

    return isConsecutive;
}

questionnaireEditor.showAppropriateButtons = function () {
    const $selectedButtons = $('.token.selected, .ign.selected');
    const selectedButtonsLength = $selectedButtons.length;
    let combineAvailable = false;

    if (selectedButtonsLength > 1) {
        const $selectedIgn = $selectedButtons.filter('.ign');
        combineAvailable = ($selectedIgn.length !== selectedButtonsLength) && questionnaireEditor.areSelectedElementsConsecutive();
    }

    $('.h-texthighlightCombineButton').toggle(combineAvailable);
    $('.h-texthighlightUngroupButton').toggle($selectedButtons.filter('[isgroup="true"]').length > 0);
    $('.h-texthighlightAddButton').toggle($selectedButtons.filter('.ign').length > 0);
    $('.h-texthighlightRemoveButton').toggle($selectedButtons.filter('.token').length > 0);

    if (selectedButtonsLength === 1) {
        questionnaireEditor.showTooltip($selectedButtons);
    } else {
        questionnaireEditor.hideTooltip();
    }
};

questionnaireEditor.saveButtonStates = function () {
    const buttonStates = [];
    $(".v-textHighlighter-input .v-questionEditableItem").each(function () {
        const $this = $(this);
        const isGroup = $this.attr('isgroup') === 'true';
        buttonStates.push({
            text: $this.text(),
            isGroup: isGroup,
            highlightable: $this.attr('highlightable'),
            choiceCode: $this.attr('choiceCode'),
            userModified: $this.attr('userModified'),
            class: $this.attr('class'),
            dataspaces: isGroup ? $this.attr('data-spaces') : null,
        });
    });
    return buttonStates;
};

questionnaireEditor.reAssignTokenPosition = function () {
    // update choice code
    const currentButtonStates = questionnaireEditor.saveButtonStates();
    const lcs = questionnaireEditor.findLongestCommonSubsequence(prevButtonStates, currentButtonStates);
    questionnaireEditor.updateButtonStatesUsingLCS(lcs, prevButtonStates, $('.v-textHighlighter-input .v-questionEditableItem'), false);

    // update mapped choice code (comapred to latest saved status in database)
    const lcsMapped = questionnaireEditor.findLongestCommonSubsequence(latestSavedStatus, currentButtonStates);
    questionnaireEditor.updateButtonStatesUsingLCS(lcsMapped, latestSavedStatus, $('.v-textHighlighter-input .v-questionEditableItem'), true);
};

questionnaireEditor.findLongestCommonSubsequence = function (savedButtonStates, currentButtonStates) {
    const savedLength = savedButtonStates.length;
    const currentLength = currentButtonStates.length;
    const lcsMatrix = Array.from({ length: savedLength + 1 }, () => Array(currentLength + 1).fill(0));

    for (let i = 1; i <= savedLength; i++) {
        for (let j = 1; j <= currentLength; j++) {
            if (savedButtonStates[i - 1].text === currentButtonStates[j - 1].text) {
                lcsMatrix[i][j] = lcsMatrix[i - 1][j - 1] + 1;
            } else {
                lcsMatrix[i][j] = Math.max(lcsMatrix[i - 1][j], lcsMatrix[i][j - 1]);
            }
        }
    }

    const lcs = [];
    let savedIndex = savedLength;
    let currentIndex = currentLength;

    while (savedIndex > 0 && currentIndex > 0) {
        if (savedButtonStates[savedIndex - 1].text === currentButtonStates[currentIndex - 1].text) {
            lcs.unshift(savedButtonStates[savedIndex - 1]);
            savedIndex--;
            currentIndex--;
        } else if (lcsMatrix[savedIndex - 1][currentIndex] > lcsMatrix[savedIndex][currentIndex - 1]) {
            savedIndex--;
        } else {
            currentIndex--;
        }
    }

    return lcs;
};

questionnaireEditor.updateButtonStatesUsingLCS = function (lcs, savedButtonStates, currentButtonStates, isComparedToLastestSaved) {
    let currentIndex = 0;
    let lcsIndex = 0;
    let incrementCounter = 0;

    let maxCurrentChoiceCode;
    if (savedButtonStates.every(state => isNaN(parseInt(state.choiceCode)))) {
        maxCurrentChoiceCode = savedButtonStates.length + 1;
    } else {
        maxCurrentChoiceCode = savedButtonStates.reduce((maxCode, state) => {
            const choiceCode = parseInt(state.choiceCode);
            return isNaN(choiceCode) ? maxCode : Math.max(maxCode, choiceCode);
        }, 0) + 1;
    }

    while (currentIndex < currentButtonStates.length) {
        const currentButton = currentButtonStates.eq(currentIndex);
        const savedState = lcs[lcsIndex];
        if (lcsIndex < lcs.length && savedState && savedState.text === currentButton.text()) {
            // Match found in LCS
            if (isComparedToLastestSaved) {
                currentButton.attr('mappedchoiceCode', savedState.choiceCode);
            }
            else {
                currentButton.attr('highlightable', savedState.highlightable);
                currentButton.attr('choiceCode', savedState.choiceCode);
                currentButton.attr('userModified', savedState.userModified);
                currentButton.attr('class', savedState.class);

                if (savedState.isGroup) {
                    currentButton.attr('isgroup', 'true');
                    currentButton.attr('data-spaces', savedState.dataspaces);
                } else {
                    currentButton.attr('isgroup', 'false');
                    currentButton.removeAttr('data-spaces');
                }
            }
            lcsIndex++;
        } else {
            // Not in LCS
            if (isComparedToLastestSaved) {
                currentButton.attr('mappedchoiceCode', maxCurrentChoiceCode + (incrementCounter++));
            }
            else {
                if (questionnaireEditor.isStopWord(currentButton.text())) {
                    currentButton.attr('highlightable', false);
                } else {
                    currentButton.attr('highlightable', true);
                }
                currentButton.attr('choiceCode', maxCurrentChoiceCode + (incrementCounter++));
                currentButton.attr('userModified', false);
            }
        }

        currentButton.toggleClass('token', currentButton.attr('highlightable') !== 'false');
        currentButton.toggleClass('ign', currentButton.attr('highlightable') === 'false');
        currentIndex++;
    }
}

questionnaireEditor.flattenStyles = function ($element) {
    function processElement($this) {
        var style = $this.attr('style') || '';
        var originalTag = $this.prop('tagName').toLowerCase();

        if ($this.is('a, img, video')) {
            return $this.clone();
        }
        if ($this.is('strong')) {
            style += 'font-weight: bold;';
        }
        if ($this.is('em')) {
            style += 'font-style: italic;';
        }
        if ($this.is('u')) {
            style += 'text-decoration: underline;';
        }
        if ($this.is('h1')) {
            style += 'font-size: 2em;';
        }
        if ($this.is('h2')) {
            style += 'font-size: 1.5em;';
        }
        if ($this.is('h3')) {
            style += 'font-size: 1.17em;';
        }
        if ($this.is('h4')) {
            style += 'font-size: 1em;';
        }
        if ($this.is('pre')) {
            style += 'font-family: monospace; white-space: pre;';
        }

        var $span = $('<span>', {
            style: style,
            'data-original-tag': originalTag
        });

        $this.contents().each(function () {
            if (this.nodeType === Node.ELEMENT_NODE) {
                var $childElement = $(this);
                var $processedChild = processElement($childElement);
                $span.append($processedChild);
            } else {
                $span.append(this);
            }
        });

        return $span;
    }

    $element.find("strong, em, u, h1, h2, h3, h4, pre").each(function () {
        var $this = $(this);
        var $span = processElement($this);

        $this.replaceWith($span);
    });
};

// ----------------- FILE UPLOAD -----------------
questionnaireEditor.setFileUploadEvent = function (context) {
    $(context).on("change", ".v-fileInput", function (e) {
        var files = e.originalEvent.target.files;
        if (files && files.length > 0) {
            var file = files[0];
            $(this).closest(".inputFileContainer").find('.file-name-section').text(file.name);
        } else {
            $(this).closest(".inputFileContainer").find('.file-name-section').text(questionnaireEditor.resources.NoFileChosen);
        }
    });
}